{ *********************************************************************** }
{                                                                         }
{ Translated Header File                                                  }
{ Part of the Delphi Visual Component Library                             }
{                                                                         }
{ Original Header File Copyright (c) 1985-2004 Microsoft Corporation      }
{  All Rights Reserved.                                                   }
{                                                                         }
{ Translation Copyright (c) 1995-2004 Borland Software Corporation        }
{                                                                         }
{ *********************************************************************** }

unit Borland.Vcl.MMSystem platform;

{$WEAKPACKAGEUNIT}

interface

uses
  System.Text, System.Runtime.InteropServices, Windows;


{***************************************************************************

                    General constants and data types

***************************************************************************}

{ general constants }
const
  MAXPNAMELEN      =  32;    { max product name length (including nil) }
  MAXERRORLENGTH   = 128;    { max error text length (including nil) }
  MAX_JOYSTICKOEMVXDNAME = 260; { max oem vxd name length (including nil) }

{***************************************************************************

                         Manufacturer and product IDs

    Used with wMid and wPid fields in WAVEOUTCAPS, WAVEINCAPS,
    MIDIOUTCAPS, MIDIINCAPS, AUXCAPS, JOYCAPS structures.

***************************************************************************}

{ manufacturer IDs }
const
  MM_MICROSOFT            = 1;       { Microsoft Corp. }

{ product IDs }
  MM_MIDI_MAPPER          = 1;       { MIDI Mapper }
  MM_WAVE_MAPPER          = 2;       { Wave Mapper }
  MM_SNDBLST_MIDIOUT      = 3;       { Sound Blaster MIDI output port }
  MM_SNDBLST_MIDIIN       = 4;       { Sound Blaster MIDI input port  }
  MM_SNDBLST_SYNTH        = 5;       { Sound Blaster internal synthesizer }
  MM_SNDBLST_WAVEOUT      = 6;       { Sound Blaster waveform output }
  MM_SNDBLST_WAVEIN       = 7;       { Sound Blaster waveform input }
  MM_ADLIB                = 9;       { Ad Lib-compatible synthesizer }
  MM_MPU401_MIDIOUT       = 10;      { MPU401-compatible MIDI output port }
  MM_MPU401_MIDIIN        = 11;      { MPU401-compatible MIDI input port }
  MM_PC_JOYSTICK          = 12;      { Joystick adapter }


{ general data types }
type
  VERSION = UINT;               { major (high byte), minor (low byte) }
  MMVERSION = UINT;             { major (high byte), minor (low byte) }
  MMRESULT = UINT;              { error return code, 0 means no error }

{ types for wType field in MMTIME struct }
const
  TIME_MS         = $0001;  { time in milliseconds }
  TIME_SAMPLES    = $0002;  { number of wave samples }
  TIME_BYTES      = $0004;  { current byte offset }
  TIME_SMPTE      = $0008;  { SMPTE time }
  TIME_MIDI       = $0010;  { MIDI time }
  TIME_TICKS      = $0020;  { Ticks within MIDI stream }

{ MMTIME data structure }
type
  [StructLayout(LayoutKind.Explicit)]
  mmtime_tag = record
    case wType: UINT of        { indicates the contents of the variant record }
     TIME_MS:      (ms: DWORD);
     TIME_SAMPLES: (sample: DWORD);
     TIME_BYTES:   (cb: DWORD);
     TIME_TICKS:   (ticks: DWORD);
     TIME_SMPTE: (
        hour: Byte;
        min: Byte;
        sec: Byte;
        frame: Byte;
        fps: Byte;
        dummy: Byte;
        pad0: Byte;   { "array[0..1] of Byte" flattened to  }
        pad1: Byte);  { comply with variant records in CLR. }
      TIME_MIDI : (songptrpos: DWORD);
  end;
  TMMTime = mmtime_tag;
  MMTIME = mmtime_tag;


{***************************************************************************

                    Multimedia Extensions Window Messages

***************************************************************************}

{ joystick }
const
  MM_JOY1MOVE         = $3A0;
  MM_JOY2MOVE         = $3A1;
  MM_JOY1ZMOVE        = $3A2;
  MM_JOY2ZMOVE        = $3A3;
  MM_JOY1BUTTONDOWN   = $3B5;
  MM_JOY2BUTTONDOWN   = $3B6;
  MM_JOY1BUTTONUP     = $3B7;
  MM_JOY2BUTTONUP     = $3B8;

{ MCI }
  MM_MCINOTIFY        = $3B9;

{ waveform output }
  MM_WOM_OPEN         = $3BB;
  MM_WOM_CLOSE        = $3BC;
  MM_WOM_DONE         = $3BD;

{ waveform input }
  MM_WIM_OPEN         = $3BE;
  MM_WIM_CLOSE        = $3BF;
  MM_WIM_DATA         = $3C0;

{ MIDI input }
  MM_MIM_OPEN         = $3C1;
  MM_MIM_CLOSE        = $3C2;
  MM_MIM_DATA         = $3C3;
  MM_MIM_LONGDATA     = $3C4;
  MM_MIM_ERROR        = $3C5;
  MM_MIM_LONGERROR    = $3C6;

{ MIDI output }
  MM_MOM_OPEN         = $3C7;
  MM_MOM_CLOSE        = $3C8;
  MM_MOM_DONE         = $3C9;

  MM_DRVM_OPEN        = $3D0;
  MM_DRVM_CLOSE       = $3D1;
  MM_DRVM_DATA        = $3D2;
  MM_DRVM_ERROR       = $3D3;

  MM_STREAM_OPEN	    = $3D4;
  MM_STREAM_CLOSE	    = $3D5;
  MM_STREAM_DONE	    = $3D6;
  MM_STREAM_ERROR	    = $3D7;

  MM_MOM_POSITIONCB   = $3CA;

  MM_MCISIGNAL        = $3CB;
  MM_MIM_MOREDATA     = $3CC;

  MM_MIXM_LINE_CHANGE     = $3D0;
  MM_MIXM_CONTROL_CHANGE  = $3D1;

{***************************************************************************

                String resource number bases (internal use)

***************************************************************************}

const
  MMSYSERR_BASE          = 0;
  WAVERR_BASE            = 32;
  MIDIERR_BASE           = 64;
  TIMERR_BASE            = 96;
  JOYERR_BASE            = 160;
  MCIERR_BASE            = 256;
  MIXERR_BASE            = 1024;

  MCI_STRING_OFFSET      = 512;
  MCI_VD_OFFSET          = 1024;
  MCI_CD_OFFSET          = 1088;
  MCI_WAVE_OFFSET        = 1152;
  MCI_SEQ_OFFSET         = 1216;

{***************************************************************************

                        General error return values

***************************************************************************}

{ general error return values }
const
  MMSYSERR_NOERROR      = 0;                  { no error }
  MMSYSERR_ERROR        = MMSYSERR_BASE + 1;  { unspecified error }
  MMSYSERR_BADDEVICEID  = MMSYSERR_BASE + 2;  { device ID out of range }
  MMSYSERR_NOTENABLED   = MMSYSERR_BASE + 3;  { driver failed enable }
  MMSYSERR_ALLOCATED    = MMSYSERR_BASE + 4;  { device already allocated }
  MMSYSERR_INVALHANDLE  = MMSYSERR_BASE + 5;  { device handle is invalid }
  MMSYSERR_NODRIVER     = MMSYSERR_BASE + 6;  { no device driver present }
  MMSYSERR_NOMEM        = MMSYSERR_BASE + 7;  { memory allocation error }
  MMSYSERR_NOTSUPPORTED = MMSYSERR_BASE + 8;  { function isn't supported }
  MMSYSERR_BADERRNUM    = MMSYSERR_BASE + 9;  { error value out of range }
  MMSYSERR_INVALFLAG    = MMSYSERR_BASE + 10; { invalid flag passed }
  MMSYSERR_INVALPARAM   = MMSYSERR_BASE + 11; { invalid parameter passed }
  MMSYSERR_HANDLEBUSY   = MMSYSERR_BASE + 12; { handle being used
                                                simultaneously on another
                                                thread (eg callback) }
  MMSYSERR_INVALIDALIAS = MMSYSERR_BASE + 13; { specified alias not found }
  MMSYSERR_BADDB        = MMSYSERR_BASE + 14; { bad registry database }
  MMSYSERR_KEYNOTFOUND  = MMSYSERR_BASE + 15; { registry key not found }
  MMSYSERR_READERROR    = MMSYSERR_BASE + 16; { registry read error }
  MMSYSERR_WRITEERROR   = MMSYSERR_BASE + 17; { registry write error }
  MMSYSERR_DELETEERROR  = MMSYSERR_BASE + 18; { registry delete error }
  MMSYSERR_VALNOTFOUND  = MMSYSERR_BASE + 19; { registry value not found }
  MMSYSERR_NODRIVERCB   = MMSYSERR_BASE + 20; { driver does not call DriverCallback }
  MMSYSERR_LASTERROR    = MMSYSERR_BASE + 20; { last error in range }

type
  HDRVR = Integer;

{***************************************************************************

                        Installable driver support

***************************************************************************}

type
  DRVCONFIGINFOEX = packed record
    dwDCISize: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDCISectionName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDCIAliasName: string;
    dnDevNode: DWORD;
  end;
  TDrvConfigInfoEx = DRVCONFIGINFOEX;

const
{ Driver messages }
  DRV_LOAD                = $0001;
  DRV_ENABLE              = $0002;
  DRV_OPEN                = $0003;
  DRV_CLOSE               = $0004;
  DRV_DISABLE             = $0005;
  DRV_FREE                = $0006;
  DRV_CONFIGURE           = $0007;
  DRV_QUERYCONFIGURE      = $0008;
  DRV_INSTALL             = $0009;
  DRV_REMOVE              = $000A;
  DRV_EXITSESSION         = $000B;
  DRV_POWER               = $000F;
  DRV_RESERVED            = $0800;
  DRV_USER                = $4000;

type
{ LPARAM of DRV_CONFIGURE message }
  tagDRVCONFIGINFO = packed record
    dwDCISize: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDCISectionName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpszDCIAliasName: string;
  end;
  TDrvConfigInfo = tagDRVCONFIGINFO;
  DRVCONFIGINFO = tagDRVCONFIGINFO;

const
{ Supported return values for DRV_CONFIGURE message }
  DRVCNF_CANCEL           = $0000;
  DRVCNF_OK               = $0001;
  DRVCNF_RESTART          = $0002;


{ installable driver function prototypes }
type 
  TFNDriverProc = function(dwDriverId: DWORD; hdrvr: HDRVR; 
    msg: UINT; lparam1, lparam2: LPARAM): Longint;

function CloseDriver(hDriver: HDRVR; lParam1, lParam2: Longint): Longint;
function OpenDriver(szDriverName: string; szSectionName: string; lParam2: Longint): HDRVR;
function SendDriverMessage(hDriver: HDRVR; message: UINT; lParam1, lParam2: Longint): Longint;
function DrvGetModuleHandle(hDriver: HDRVR): HMODULE;
function GetDriverModuleHandle(hDriver: HDRVR): HMODULE;
function DefDriverProc(dwDriverIdentifier: DWORD; hdrvr: HDRVR; uMsg: UINT;
  lParam1, lParam2: LPARAM): Longint;

{ return values from DriverProc() function }
const
  DRV_CANCEL             = DRVCNF_CANCEL;
  DRV_OK                 = DRVCNF_OK;
  DRV_RESTART            = DRVCNF_RESTART;

  DRV_MCI_FIRST          = DRV_RESERVED;
  DRV_MCI_LAST           = DRV_RESERVED + $FFF;


{***************************************************************************

                          Driver callback support

***************************************************************************}

{ flags used with waveOutOpen(), waveInOpen(), midiInOpen(), and }
{ midiOutOpen() to specify the type of the dwCallback parameter. }

const
  CALLBACK_TYPEMASK   = $00070000;    { callback type mask }
  CALLBACK_NULL       = $00000000;    { no callback }
  CALLBACK_WINDOW     = $00010000;    { dwCallback is a HWND }
  CALLBACK_TASK       = $00020000;    { dwCallback is a HTASK }
  CALLBACK_FUNCTION   = $00030000;    { dwCallback is a FARPROC }
  CALLBACK_THREAD     = CALLBACK_TASK;{ thread ID replaces 16 bit task }
  CALLBACK_EVENT      = $00050000;    { dwCallback is an EVENT Handle }

{ driver callback prototypes }

type
  TFNDrvCallBack = procedure(hdrvr: HDRVR; uMsg: UINT; dwUser: DWORD;
    dw1, dw2: DWORD);


{***************************************************************************

                    General MMSYSTEM support

***************************************************************************}

function mmsystemGetVersion: UINT;

{***************************************************************************

                            Sound support

***************************************************************************}

function sndPlaySound(lpszSoundName: string; uFlags: UINT): BOOL; overload;
function sndPlaySound(lpszSoundName: IntPtr; uFlags: UINT): BOOL; overload;
function sndPlaySoundA(lpszSoundName: string; uFlags: UINT): BOOL;
function sndPlaySoundW(lpszSoundName: string; uFlags: UINT): BOOL;

{ flag values for wFlags parameter }
const
  SND_SYNC            = $0000;  { play synchronously (default) }
  SND_ASYNC           = $0001;  { play asynchronously }
  SND_NODEFAULT       = $0002;  { don't use default sound }
  SND_MEMORY          = $0004;  { lpszSoundName points to a memory file }
  SND_LOOP            = $0008;  { loop the sound until next sndPlaySound }
  SND_NOSTOP          = $0010;  { don't stop any currently playing sound }

  SND_NOWAIT          = $00002000;  { don't wait if the driver is busy }
  SND_ALIAS           = $00010000;  { name is a registry alias }
  SND_ALIAS_ID        = $00110000;  { alias is a predefined ID }
  SND_FILENAME        = $00020000;  { name is file name }
  SND_RESOURCE        = $00040004;  { name is resource name or atom }
  SND_PURGE           = $0040;      { purge non-static events for task }
  SND_APPLICATION     = $0080;      { look for application specific association }

  SND_ALIAS_START     = 0;   { alias base }

  SND_ALIAS_SYSTEMASTERISK       = SND_ALIAS_START + (Longint(Ord('S')) or (Longint(Ord('*')) shl 8));
  SND_ALIAS_SYSTEMQUESTION       = SND_ALIAS_START + (Longint(Ord('S')) or (Longint(Ord('?')) shl 8));
  SND_ALIAS_SYSTEMHAND           = SND_ALIAS_START + (Longint(Ord('S')) or (Longint(Ord('H')) shl 8));
  SND_ALIAS_SYSTEMEXIT           = SND_ALIAS_START + (Longint(Ord('S')) or (Longint(Ord('E')) shl 8));
  SND_ALIAS_SYSTEMSTART          = SND_ALIAS_START + (Longint(Ord('S')) or (Longint(Ord('S')) shl 8));
  SND_ALIAS_SYSTEMWELCOME        = SND_ALIAS_START + (Longint(Ord('S')) or (Longint(Ord('W')) shl 8));
  SND_ALIAS_SYSTEMEXCLAMATION    = SND_ALIAS_START + (Longint(Ord('S')) or (Longint(Ord('!')) shl 8));
  SND_ALIAS_SYSTEMDEFAULT        = SND_ALIAS_START + (Longint(Ord('S')) or (Longint(Ord('D')) shl 8));

function PlaySound(pszSound: string; hmod: HMODULE; fdwSound: DWORD): BOOL;
function PlaySoundA(pszSound: string; hmod: HMODULE; fdwSound: DWORD): BOOL; 
function PlaySoundW(pszSound: string; hmod: HMODULE; fdwSound: DWORD): BOOL; 

{***************************************************************************

                        Waveform audio support

***************************************************************************}

{ waveform audio error return values }
const
  WAVERR_BADFORMAT      = WAVERR_BASE + 0;    { unsupported wave format }
  WAVERR_STILLPLAYING   = WAVERR_BASE + 1;    { still something playing }
  WAVERR_UNPREPARED     = WAVERR_BASE + 2;    { header not prepared }
  WAVERR_SYNC           = WAVERR_BASE + 3;    { device is synchronous }
  WAVERR_LASTERROR      = WAVERR_BASE + 3;    { last error in range }

{ waveform audio data types }
type
  HWAVE = Integer;
  HWAVEIN = Integer;
  HWAVEOUT = Integer;

type
  TFNWaveCallBack = TFNDrvCallBack;

{ wave callback messages }
const
  WOM_OPEN        = MM_WOM_OPEN;
  WOM_CLOSE       = MM_WOM_CLOSE;
  WOM_DONE        = MM_WOM_DONE;
  WIM_OPEN        = MM_WIM_OPEN;
  WIM_CLOSE       = MM_WIM_CLOSE;
  WIM_DATA        = MM_WIM_DATA;

{ device ID for wave device mapper }
  WAVE_MAPPER     = UINT(-1);

{ flags for dwFlags parameter in waveOutOpen() and waveInOpen() }
  WAVE_FORMAT_QUERY     = $0001;
  WAVE_ALLOWSYNC        = $0002;
  WAVE_MAPPED           = $0004;

{ wave data block header }
type
  [StructLayout(LayoutKind.Sequential)]
  wavehdr_tag = record
    lpData: IntPtr;             { pointer to locked data buffer }
    dwBufferLength: DWORD;      { length of data buffer }
    dwBytesRecorded: DWORD;     { used for input only }
    dwUser: DWORD;              { for client's use }
    dwFlags: DWORD;             { assorted flags (see defines) }
    dwLoops: DWORD;             { loop control counter }
    lpNext: IntPtr;             { reserved for driver }
    reserved: DWORD;            { reserved for driver }
  end;
  TWaveHdr = wavehdr_tag;
  WAVEHDR = wavehdr_tag;


{ flags for dwFlags field of WAVEHDR }
const
  WHDR_DONE       = $00000001;  { done bit }
  WHDR_PREPARED   = $00000002;  { set if this header has been prepared }
  WHDR_BEGINLOOP  = $00000004;  { loop start block }
  WHDR_ENDLOOP    = $00000008;  { loop end block }
  WHDR_INQUEUE    = $00000010;  { reserved for driver }

{ waveform output device capabilities structure }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagWAVEOUTCAPS = record
    wMid: Word;                 { manufacturer ID }
    wPid: Word;                 { product ID }
    vDriverVersion: MMVERSION;  { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;            { product name (NULL terminated string) }
    dwFormats: DWORD;           { formats supported }
    wChannels: Word;            { number of sources supported }
    dwSupport: DWORD;           { functionality supported by driver }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagWAVEOUTCAPSA = record
    wMid: Word;                 { manufacturer ID }
    wPid: Word;                 { product ID }
    vDriverVersion: MMVERSION;  { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;            { product name (NULL terminated string) }
    dwFormats: DWORD;           { formats supported }
    wChannels: Word;            { number of sources supported }
    dwSupport: DWORD;           { functionality supported by driver }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagWAVEOUTCAPSW = record
    wMid: Word;                 { manufacturer ID }
    wPid: Word;                 { product ID }
    vDriverVersion: MMVERSION;  { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;            { product name (NULL terminated string) }
    dwFormats: DWORD;           { formats supported }
    wChannels: Word;            { number of sources supported }
    dwSupport: DWORD;           { functionality supported by driver }
  end;
  TWaveOutCaps = tagWAVEOUTCAPS;
  TWaveOutCapsA = tagWAVEOUTCAPSA;
  TWaveOutCapsW = tagWAVEOUTCAPSW;
  WAVEOUTCAPS = tagWAVEOUTCAPS;
  WAVEOUTCAPSA = tagWAVEOUTCAPSA;
  WAVEOUTCAPSW = tagWAVEOUTCAPSW;


{ flags for dwSupport field of WAVEOUTCAPS }
const
  WAVECAPS_PITCH          = $0001;   { supports pitch control }
  WAVECAPS_PLAYBACKRATE   = $0002;   { supports playback rate control }
  WAVECAPS_VOLUME         = $0004;   { supports volume control }
  WAVECAPS_LRVOLUME       = $0008;   { separate left-right volume control }
  WAVECAPS_SYNC           = $0010;
  WAVECAPS_SAMPLEACCURATE = $0020;
  WAVECAPS_DIRECTSOUND    = $0040;

{ waveform input device capabilities structure }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagWAVEINCAPS = record
    wMid: Word;                   { manufacturer ID }
    wPid: Word;                   { product ID }
    vDriverVersion: MMVERSION;    { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;              { product name (NULL terminated string) }
    dwFormats: DWORD;             { formats supported }
    wChannels: Word;              { number of channels supported }
    wReserved1: Word;             { structure packing }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagWAVEINCAPSA = record
    wMid: Word;                   { manufacturer ID }
    wPid: Word;                   { product ID }
    vDriverVersion: MMVERSION;    { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;              { product name (NULL terminated string) }
    dwFormats: DWORD;             { formats supported }
    wChannels: Word;              { number of channels supported }
    wReserved1: Word;             { structure packing }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagWAVEINCAPSW = record
    wMid: Word;                   { manufacturer ID }
    wPid: Word;                   { product ID }
    vDriverVersion: MMVERSION;    { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;              { product name (NULL terminated string) }
    dwFormats: DWORD;             { formats supported }
    wChannels: Word;              { number of channels supported }
    wReserved1: Word;             { structure packing }
  end;
  TWaveInCaps = tagWAVEINCAPS;
  TWaveInCapsA = tagWAVEINCAPSA;
  TWaveInCapsW = tagWAVEINCAPSW;
  WAVEINCAPS = tagWAVEINCAPS;
  WAVEINCAPSA = tagWAVEINCAPSA;
  WAVEINCAPSW = tagWAVEINCAPSW;


{ defines for dwFormat field of WAVEINCAPS and WAVEOUTCAPS }
const
  WAVE_INVALIDFORMAT     = $00000000;       { invalid format }
  WAVE_FORMAT_1M08       = $00000001;       { 11.025 kHz, Mono,   8-bit  }
  WAVE_FORMAT_1S08       = $00000002;       { 11.025 kHz, Stereo, 8-bit  }
  WAVE_FORMAT_1M16       = $00000004;       { 11.025 kHz, Mono,   16-bit }
  WAVE_FORMAT_1S16       = $00000008;       { 11.025 kHz, Stereo, 16-bit }
  WAVE_FORMAT_2M08       = $00000010;       { 22.05  kHz, Mono,   8-bit  }
  WAVE_FORMAT_2S08       = $00000020;       { 22.05  kHz, Stereo, 8-bit  }
  WAVE_FORMAT_2M16       = $00000040;       { 22.05  kHz, Mono,   16-bit }
  WAVE_FORMAT_2S16       = $00000080;       { 22.05  kHz, Stereo, 16-bit }
  WAVE_FORMAT_4M08       = $00000100;       { 44.1   kHz, Mono,   8-bit  }
  WAVE_FORMAT_4S08       = $00000200;       { 44.1   kHz, Stereo, 8-bit  }
  WAVE_FORMAT_4M16       = $00000400;       { 44.1   kHz, Mono,   16-bit }
  WAVE_FORMAT_4S16       = $00000800;       { 44.1   kHz, Stereo, 16-bit }

{ general waveform format structure (information common to all formats) }
type
  waveformat_tag = packed record
    wFormatTag: Word;         { format type }
    nChannels: Word;          { number of channels (i.e. mono, stereo, etc.) }
    nSamplesPerSec: DWORD;  { sample rate }
    nAvgBytesPerSec: DWORD; { for buffer estimation }
    nBlockAlign: Word;      { block size of data }
  end;
  TWaveFormat = waveformat_tag;
  WAVEFORMAT = waveformat_tag;

{ flags for wFormatTag field of WAVEFORMAT }
const
  WAVE_FORMAT_PCM     = 1;

{ specific waveform format structure for PCM data }
type
  [StructLayout(LayoutKind.Sequential)]
  pcmwaveformat_tag = record
      wf: TWaveFormat;
      wBitsPerSample: Word;
   end;
  TPCMWaveFormat = pcmwaveformat_tag;
  PCMWAVEFORMAT = pcmwaveformat_tag;


{ extended waveform format structure used for all non-PCM formats. this
  structure is common to all non-PCM formats. }

  [StructLayout(LayoutKind.Sequential)]
  tWAVEFORMATEX = packed record
    wFormatTag: Word;         { format type }
    nChannels: Word;          { number of channels (i.e. mono, stereo, etc.) }
    nSamplesPerSec: DWORD;  { sample rate }
    nAvgBytesPerSec: DWORD; { for buffer estimation }
    nBlockAlign: Word;      { block size of data }
    wBitsPerSample: Word;   { number of bits per sample of mono data }
    cbSize: Word;           { the count in bytes of the size of }
  end;


{ waveform audio function prototypes }
function waveOutGetNumDevs: UINT;

function waveOutGetDevCaps(uDeviceID: UINT; out lpCaps: TWaveOutCaps; uSize: UINT): MMRESULT;
function waveOutGetDevCapsA(uDeviceID: UINT; out lpCaps: TWaveOutCapsA; uSize: UINT): MMRESULT;
function waveOutGetDevCapsW(uDeviceID: UINT; out lpCaps: TWaveOutCapsW; uSize: UINT): MMRESULT;
function waveOutGetVolume(hwo: HWAVEOUT; out lpdwVolume: DWORD): MMRESULT;
function waveOutSetVolume(hwo: HWAVEOUT; dwVolume: DWORD): MMRESULT;
function waveOutGetErrorText(mmrError: MMRESULT; lpText: StringBuilder; uSize: UINT): MMRESULT;
function waveOutGetErrorTextA(mmrError: MMRESULT; lpText: StringBuilder; uSize: UINT): MMRESULT;
function waveOutGetErrorTextW(mmrError: MMRESULT; lpText: StringBuilder; uSize: UINT): MMRESULT;
function waveOutOpen(out lphWaveOut: HWaveOut; uDeviceID: UINT;
  const lpFormat: TWaveFormatEx; dwCallback, dwInstance, dwFlags: DWORD): MMRESULT; overload;
function waveOutOpen(lphWaveOut: IntPtr; uDeviceID: UINT;
  const lpFormat: TWaveFormatEx; dwCallback, dwInstance, dwFlags: DWORD): MMRESULT; overload;
function waveOutClose(hWaveOut: HWAVEOUT): MMRESULT;
function waveOutPrepareHeader(hWaveOut: HWAVEOUT; var lpWaveOutHdr: TWaveHdr;
  uSize: UINT): MMRESULT;
function waveOutUnprepareHeader(hWaveOut: HWAVEOUT; var lpWaveOutHdr: TWaveHdr;
  uSize: UINT): MMRESULT;
function waveOutWrite(hWaveOut: HWAVEOUT; const lpWaveOutHdr: TWaveHdr;
  uSize: UINT): MMRESULT;
function waveOutPause(hWaveOut: HWAVEOUT): MMRESULT;
function waveOutRestart(hWaveOut: HWAVEOUT): MMRESULT;
function waveOutReset(hWaveOut: HWAVEOUT): MMRESULT;
function waveOutBreakLoop(hWaveOut: HWAVEOUT): MMRESULT;
function waveOutGetPosition(hWaveOut: HWAVEOUT; var lpInfo: TMMTime; uSize: UINT): MMRESULT;
function waveOutGetPitch(hWaveOut: HWAVEOUT; out lpdwPitch: DWORD): MMRESULT;
function waveOutSetPitch(hWaveOut: HWAVEOUT; dwPitch: DWORD): MMRESULT;
function waveOutGetPlaybackRate(hWaveOut: HWAVEOUT; out lpdwRate: DWORD): MMRESULT;
function waveOutSetPlaybackRate(hWaveOut: HWAVEOUT; dwRate: DWORD): MMRESULT;
function waveOutGetID(hWaveOut: HWAVEOUT; out lpuDeviceID: UINT): MMRESULT;
function waveOutMessage(hWaveOut: HWAVEOUT; uMessage: UINT; dw1, dw2: DWORD): Longint;
function waveInGetNumDevs: UINT;
function waveInGetDevCaps(hwo: HWAVEOUT; out lpCaps: TWaveInCaps; uSize: UINT): MMRESULT;
function waveInGetDevCapsA(hwo: HWAVEOUT; out lpCaps: TWaveInCapsA; uSize: UINT): MMRESULT;
function waveInGetDevCapsW(hwo: HWAVEOUT; out lpCaps: TWaveInCapsW; uSize: UINT): MMRESULT;
function waveInGetErrorText(mmrError: MMRESULT; lpText: StringBuilder; uSize: UINT): MMRESULT;
function waveInGetErrorTextA(mmrError: MMRESULT; lpText: StringBuilder; uSize: UINT): MMRESULT;
function waveInGetErrorTextW(mmrError: MMRESULT; lpText: StringBuilder; uSize: UINT): MMRESULT;
function waveInOpen(out lphWaveIn: HWAVEIN; uDeviceID: UINT;
  const lpFormatEx: TWaveFormatEx; dwCallback, dwInstance, dwFlags: DWORD): MMRESULT; overload;
function waveInOpen(lphWaveIn: IntPtr; uDeviceID: UINT;
  const lpFormatEx: TWaveFormatEx; dwCallback, dwInstance, dwFlags: DWORD): MMRESULT; overload;
function waveInClose(hWaveIn: HWAVEIN): MMRESULT;
function waveInPrepareHeader(hWaveIn: HWAVEIN; var lpWaveInHdr: TWaveHdr;
  uSize: UINT): MMRESULT;
function waveInUnprepareHeader(hWaveIn: HWAVEIN; var lpWaveInHdr: TWaveHdr;
  uSize: UINT): MMRESULT;
function waveInAddBuffer(hWaveIn: HWAVEIN; var lpWaveInHdr: TWaveHdr;
  uSize: UINT): MMRESULT;
function waveInStart(hWaveIn: HWAVEIN): MMRESULT;
function waveInStop(hWaveIn: HWAVEIN): MMRESULT;
function waveInReset(hWaveIn: HWAVEIN): MMRESULT;
function waveInGetPosition(hWaveIn: HWAVEIN; var lpInfo: TMMTime;
  uSize: UINT): MMRESULT;
function waveInGetID(hWaveIn: HWAVEIN; out lpuDeviceID: UINT): MMRESULT;
function waveInMessage(hWaveIn: HWAVEIN; uMessage: UINT;
  dw1, dw2: DWORD): MMRESULT;

{***************************************************************************

                            MIDI audio support

***************************************************************************}

{ MIDI error return values }
const
  MIDIERR_UNPREPARED    = MIDIERR_BASE + 0;   { header not prepared }
  MIDIERR_STILLPLAYING  = MIDIERR_BASE + 1;   { still something playing }
  MIDIERR_NOMAP         = MIDIERR_BASE + 2;   { no current map }
  MIDIERR_NOTREADY      = MIDIERR_BASE + 3;   { hardware is still busy }
  MIDIERR_NODEVICE      = MIDIERR_BASE + 4;   { port no longer connected }
  MIDIERR_INVALIDSETUP  = MIDIERR_BASE + 5;   { invalid setup }
  MIDIERR_BADOPENMODE   = MIDIERR_BASE + 6;   { operation unsupported w/ open mode }
  MIDIERR_DONT_CONTINUE = MIDIERR_BASE + 7;   { thru device 'eating' a message }
  MIDIERR_LASTERROR     = MIDIERR_BASE + 5;   { last error in range }

{ MIDI audio data types }
type
  HMIDI = Integer;
  HMIDIIN = Integer;
  HMIDIOUT = Integer;
  HMIDISTRM = Integer;

type
  TFNMidiCallBack = TFNDrvCallBack;

const
  MIDIPATCHSIZE   = 128;

type
  TPatchArray = array[0..MIDIPATCHSIZE-1] of Word;

  TKeyArray = array[0..MIDIPATCHSIZE-1] of Word;


{ MIDI callback messages }
const
  MIM_OPEN        = MM_MIM_OPEN;
  MIM_CLOSE       = MM_MIM_CLOSE;
  MIM_DATA        = MM_MIM_DATA;
  MIM_LONGDATA    = MM_MIM_LONGDATA;
  MIM_ERROR       = MM_MIM_ERROR;
  MIM_LONGERROR   = MM_MIM_LONGERROR;
  MOM_OPEN        = MM_MOM_OPEN;
  MOM_CLOSE       = MM_MOM_CLOSE;
  MOM_DONE        = MM_MOM_DONE;

  MIM_MOREDATA    = MM_MIM_MOREDATA;
  MOM_POSITIONCB  = MM_MOM_POSITIONCB;

{ device ID for MIDI mapper }
  MIDIMAPPER     = UINT(-1);
  MIDI_MAPPER    = UINT(-1);

{ flags for dwFlags parm of midiInOpen() }
  MIDI_IO_STATUS = $00000020;

{ flags for wFlags parm of midiOutCachePatches(), midiOutCacheDrumPatches() }
  MIDI_CACHE_ALL      = 1;
  MIDI_CACHE_BESTFIT  = 2;
  MIDI_CACHE_QUERY    = 3;
  MIDI_UNCACHE        = 4;

{ MIDI output device capabilities structure }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMIDIOUTCAPS = record
    wMid: Word;                  { manufacturer ID }
    wPid: Word;                  { product ID }
    vDriverVersion: MMVERSION;   { version of the driver }
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=MAXPNAMELEN)]
    szPname: string;             { product name (NULL terminated string) }
    wTechnology: Word;           { type of device }
    wVoices: Word;               { # of voices (internal synth only) }
    wNotes: Word;                { max # of notes (internal synth only) }
    wChannelMask: Word;          { channels used (internal synth only) }
    dwSupport: DWORD;            { functionality supported by driver }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMIDIOUTCAPSA = record
    wMid: Word;                  { manufacturer ID }
    wPid: Word;                  { product ID }
    vDriverVersion: MMVERSION;   { version of the driver }
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=MAXPNAMELEN)]
    szPname: string;             { product name (NULL terminated string) }
    wTechnology: Word;           { type of device }
    wVoices: Word;               { # of voices (internal synth only) }
    wNotes: Word;                { max # of notes (internal synth only) }
    wChannelMask: Word;          { channels used (internal synth only) }
    dwSupport: DWORD;            { functionality supported by driver }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMIDIOUTCAPSW = record
    wMid: Word;                  { manufacturer ID }
    wPid: Word;                  { product ID }
    vDriverVersion: MMVERSION;   { version of the driver }
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=MAXPNAMELEN)]
    szPname: string;             { product name (NULL terminated string) }
    wTechnology: Word;           { type of device }
    wVoices: Word;               { # of voices (internal synth only) }
    wNotes: Word;                { max # of notes (internal synth only) }
    wChannelMask: Word;          { channels used (internal synth only) }
    dwSupport: DWORD;            { functionality supported by driver }
  end;
  TMidiOutCaps = tagMIDIOUTCAPS;
  TMidiOutCapsA = tagMIDIOUTCAPSA;
  TMidiOutCapsW = tagMIDIOUTCAPSW;
  MIDIOUTCAPS = tagMIDIOUTCAPS;
  MIDIOUTCAPSA = tagMIDIOUTCAPSA;
  MIDIOUTCAPSW = tagMIDIOUTCAPSW;


{ flags for wTechnology field of MIDIOUTCAPS structure }
const
  MOD_MIDIPORT    = 1;  { output port }
  MOD_SYNTH       = 2;  { generic internal synth }
  MOD_SQSYNTH     = 3;  { square wave internal synth }
  MOD_FMSYNTH     = 4;  { FM internal synth }
  MOD_MAPPER      = 5;  { MIDI mapper }

{ flags for dwSupport field of MIDIOUTCAPS structure }
const
  MIDICAPS_VOLUME          = $0001;  { supports volume control }
  MIDICAPS_LRVOLUME        = $0002;  { separate left-right volume control }
  MIDICAPS_CACHE           = $0004;
  MIDICAPS_STREAM          = $0008;  { driver supports midiStreamOut directly }

{ MIDI output device capabilities structure }

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMIDIINCAPS = record
    wMid: Word;                  { manufacturer ID }
    wPid: Word;                  { product ID }
    vDriverVersion: MMVERSION;   { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;             { product name (NULL terminated string) }
    dwSupport: DWORD;            { functionality supported by driver }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMIDIINCAPSA = record
    wMid: Word;                  { manufacturer ID }
    wPid: Word;                  { product ID }
    vDriverVersion: MMVERSION;   { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;             { product name (NULL terminated string) }
    dwSupport: DWORD;            { functionality supported by driver }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMIDIINCAPSW = record
    wMid: Word;                  { manufacturer ID }
    wPid: Word;                  { product ID }
    vDriverVersion: MMVERSION;   { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;             { product name (NULL terminated string) }
    dwSupport: DWORD;            { functionality supported by driver }
  end;
  TMidiInCaps = tagMIDIINCAPS;
  TMidiInCapsA = tagMIDIINCAPSA;
  TMidiInCapsW = tagMIDIINCAPSW;
  MIDIINCAPS = tagMIDIINCAPS;
  MIDIINCAPSA = tagMIDIINCAPSA;
  MIDIINCAPSW = tagMIDIINCAPSW;

{ MIDI data block header }
type
  [StructLayout(LayoutKind.Sequential)]
  midihdr_tag = record
    lpData: IntPtr;              { pointer to locked data block }
    dwBufferLength: DWORD;       { length of data in data block }
    dwBytesRecorded: DWORD;      { used for input only }
    dwUser: DWORD;               { for client's use }
    dwFlags: DWORD;              { assorted flags (see defines) }
    lpNext: IntPtr;              { reserved for driver }
    reserved: DWORD;             { reserved for driver }
    dwOffset: DWORD;             { Callback offset into buffer }
    [MarshalAs(UnmanagedType.ByValArray, SizeConst=8)]
    dwReserved: array[0..7] of DWORD; { Reserved for MMSYSTEM }
  end;
  TMidiHdr = midihdr_tag;
  MIDIHDR = midihdr_tag;

  [StructLayout(LayoutKind.Sequential)]
  midievent_tag = record
    dwDeltaTime: DWORD;          { Ticks since last event }
    dwStreamID: DWORD;           { Reserved; must be zero }
    dwEvent: DWORD;              { Event type and parameters }
    dwParms: IntPtr;             { Parameters if this is a long event }
                                 { array[0..0] of DWORD }
  end;
  TMidiEvent = midievent_tag;
  MIDIEVENT = midievent_tag;

  [StructLayout(LayoutKind.Sequential)]
  midistrmbuffver_tag = record
    dwVersion: DWORD;                  { Stream buffer format version }
    dwMid: DWORD;                      { Manufacturer ID as defined in MMREG.H }
    dwOEMVersion: DWORD;               { Manufacturer version for custom ext }
  end;
  TMidiStrmBuffVer = midistrmbuffver_tag;
  MIDISTRMBUFFVER = midistrmbuffver_tag;

{ flags for dwFlags field of MIDIHDR structure }
const
  MHDR_DONE       = $00000001;       { done bit }
  MHDR_PREPARED   = $00000002;       { set if header prepared }
  MHDR_INQUEUE    = $00000004;       { reserved for driver }
  MHDR_ISSTRM     = $00000008;       { Buffer is stream buffer }

(* 
  Type codes which go in the high byte of the event DWORD of a stream buffer 
 
  Type codes 00-7F contain parameters within the low 24 bits 
  Type codes 80-FF contain a length of their parameter in the low 24 
  bits, followed by their parameter data in the buffer. The event 
  DWORD contains the exact byte length; the parm data itself must be
  padded to be an even multiple of 4 bytes long. 
*) 

  MEVT_F_SHORT       = $00000000;
  MEVT_F_LONG        = $80000000;
  MEVT_F_CALLBACK    = $40000000;

  MEVT_SHORTMSG     = $00;    { parm = shortmsg for midiOutShortMsg }
  MEVT_TEMPO        = $01;    { parm = new tempo in microsec/qn     }
  MEVT_NOP          = $02;    { parm = unused; does nothing         }

{ 0x04-0x7F reserved }

  MEVT_LONGMSG      = $80;    { parm = bytes to send verbatim       }
  MEVT_COMMENT      = $82;    { parm = comment data                 }
  MEVT_VERSION      = $84;    { parm = MIDISTRMBUFFVER struct       }

{ 0x81-0xFF reserved }

  MIDISTRM_ERROR    =  -2;

{ Structures and defines for midiStreamProperty }
  MIDIPROP_SET       = $80000000;
  MIDIPROP_GET       = $40000000;

{ These are intentionally both non-zero so the app cannot accidentally
  leave the operation off and happen to appear to work due to default
  action. }
  MIDIPROP_TIMEDIV   = $00000001;
  MIDIPROP_TEMPO     = $00000002;

type
  [StructLayout(LayoutKind.Sequential)]
  midiproptimediv_tag = record
    cbStruct: DWORD;
    dwTimeDiv: DWORD;
  end;
  TMidiPropTimeDiv = midiproptimediv_tag;
  MIDIPROPTIMEDIV = midiproptimediv_tag;

  [StructLayout(LayoutKind.Sequential)]
  midiproptempo_tag = record
    cbStruct: DWORD;
    dwTempo: DWORD;
  end;
  TMidiPropTempo = midiproptempo_tag;
  MIDIPROPTEMPO = midiproptempo_tag;

{ MIDI function prototypes }
         
function midiOutGetNumDevs: UINT;
function midiStreamOpen(out phms: HMIDISTRM; [in] var puDeviceID: UINT;
  cMidi, dwCallback, dwInstance, fdwOpen: DWORD): MMRESULT;
function midiStreamClose(hms: HMIDISTRM): MMRESULT;
function midiStreamProperty(hms: HMIDISTRM; var lppropdata: TMidiPropTempo; dwProperty: DWORD): MMRESULT; overload;
function midiStreamProperty(hms: HMIDISTRM; var lppropdata: TMidiPropTimeDiv; dwProperty: DWORD): MMRESULT; overload;
function midiStreamPosition(hms: HMIDISTRM; out lpmmt: TMMTime; cbmmt: UINT): MMRESULT;
function midiStreamOut(hms: HMIDISTRM; const pmh: TMidiHdr; cbmh: UINT): MMRESULT;
function midiStreamPause(hms: HMIDISTRM): MMRESULT;
function midiStreamRestart(hms: HMIDISTRM): MMRESULT;
function midiStreamStop(hms: HMIDISTRM): MMRESULT;
function midiConnect(hmi: HMIDI; hmo: HMIDIOUT; pReserved: IntPtr): MMRESULT;
function midiDisconnect(hmi: HMIDI; hmo: HMIDIOUT; pReserved: IntPtr): MMRESULT;
function midiOutGetDevCaps(uDeviceID: UINT; out lpCaps: TMidiOutCaps; uSize: UINT): MMRESULT;
function midiOutGetDevCapsA(uDeviceID: UINT; out lpCaps: TMidiOutCapsA; uSize: UINT): MMRESULT;
function midiOutGetDevCapsW(uDeviceID: UINT; out lpCaps: TMidiOutCapsW; uSize: UINT): MMRESULT;
function midiOutGetVolume(hmo: HMIDIOUT; out lpdwVolume: DWORD): MMRESULT;
function midiOutSetVolume(hmo: HMIDIOUT; dwVolume: DWORD): MMRESULT;
function midiOutGetErrorText(mmrError: MMRESULT; pszText: StringBuilder; uSize: UINT): MMRESULT;
function midiOutGetErrorTextA(mmrError: MMRESULT; pszText: StringBuilder; uSize: UINT): MMRESULT;
function midiOutGetErrorTextW(mmrError: MMRESULT; pszText: StringBuilder; uSize: UINT): MMRESULT;
function midiOutOpen([in] var lphMidiOut: HMIDIOUT; uDeviceID: UINT;
  dwCallback, dwInstance, dwFlags: DWORD): MMRESULT;
function midiOutClose(hMidiOut: HMIDIOUT): MMRESULT;
function midiOutPrepareHeader(hMidiOut: HMIDIOUT; var lpMidiOutHdr: TMidiHdr; uSize: UINT): MMRESULT;
function midiOutUnprepareHeader(hMidiOut: HMIDIOUT; var lpMidiOutHdr: TMidiHdr; uSize: UINT): MMRESULT;
function midiOutShortMsg(hMidiOut: HMIDIOUT; dwMsg: DWORD): MMRESULT;
function midiOutLongMsg(hMidiOut: HMIDIOUT; const lpMidiOutHdr: TMidiHdr; uSize: UINT): MMRESULT;
function midiOutReset(hMidiOut: HMIDIOUT): MMRESULT;
function midiOutCachePatches(hMidiOut: HMIDIOUT;
  uBank: UINT; [in] lpwPatchArray: TPatchArray; uFlags: UINT): MMRESULT;
function midiOutCacheDrumPatches(hMidiOut: HMIDIOUT;
  uPatch: UINT; [in] lpwKeyArray: TKeyArray; uFlags: UINT): MMRESULT;
function midiOutGetID(hMidiOut: HMIDIOUT; out lpuDeviceID: UINT): MMRESULT;
function midiOutMessage(hMidiOut: HMIDIOUT; uMessage: UINT; dw1, dw2: DWORD): MMRESULT;
function midiInGetNumDevs: UINT;
function midiInGetDevCaps(DeviceID: UINT; out lpCaps: TMidiInCaps; uSize: UINT): MMRESULT;
function midiInGetDevCapsA(DeviceID: UINT; out lpCaps: TMidiInCapsA; uSize: UINT): MMRESULT;
function midiInGetDevCapsW(DeviceID: UINT; out lpCaps: TMidiInCapsW; uSize: UINT): MMRESULT;
function midiInGetErrorText(mmrError: MMRESULT; pszText: StringBuilder; uSize: UINT): MMRESULT;
function midiInGetErrorTextA(mmrError: MMRESULT; pszText: StringBuilder; uSize: UINT): MMRESULT;
function midiInGetErrorTextW(mmrError: MMRESULT; pszText: StringBuilder; uSize: UINT): MMRESULT;
function midiInOpen(out lphMidiIn: HMIDIIN; uDeviceID: UINT;
  dwCallback, dwInstance, dwFlags: DWORD): MMRESULT;
function midiInClose(hMidiIn: HMIDIIN): MMRESULT;
function midiInPrepareHeader(hMidiIn: HMIDIIN; var lpMidiInHdr: TMidiHdr; uSize: UINT): MMRESULT;
function midiInUnprepareHeader(hMidiIn: HMIDIIN; var lpMidiInHdr: TMidiHdr; uSize: UINT): MMRESULT;
function midiInAddBuffer(hMidiIn: HMIDIIN; const lpMidiInHdr: TMidiHdr; uSize: UINT): MMRESULT;
function midiInStart(hMidiIn: HMIDIIN): MMRESULT;
function midiInStop(hMidiIn: HMIDIIN): MMRESULT;
function midiInReset(hMidiIn: HMIDIIN): MMRESULT;
function midiInGetID(hMidiIn: HMIDIIN; out lpuDeviceID: UINT): MMRESULT;
function midiInMessage(hMidiIn: HMIDIIN; uMessage: UINT; dw1, dw2: DWORD): MMRESULT;


{***************************************************************************

                        Auxiliary audio support

***************************************************************************}

{ device ID for aux device mapper }
const
  AUX_MAPPER     = UINT(-1);

{ Auxiliary audio device capabilities structure }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagAUXCAPS = record
    wMid: Word;                  { manufacturer ID }
    wPid: Word;                  { product ID }
    vDriverVersion: MMVERSION;   { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;             { product name (NULL terminated string) }
    wTechnology: Word;           { type of device }
    dwSupport: DWORD;            { functionality supported by driver }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagAUXCAPSA = record
    wMid: Word;                  { manufacturer ID }
    wPid: Word;                  { product ID }
    vDriverVersion: MMVERSION;   { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;             { product name (NULL terminated string) }
    wTechnology: Word;           { type of device }
    dwSupport: DWORD;            { functionality supported by driver }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagAUXCAPSW = record
    wMid: Word;                  { manufacturer ID }
    wPid: Word;                  { product ID }
    vDriverVersion: MMVERSION;   { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;             { product name (NULL terminated string) }
    wTechnology: Word;           { type of device }
    dwSupport: DWORD;            { functionality supported by driver }
  end;
  TAuxCaps = tagAUXCAPS;
  TAuxCapsA = tagAUXCAPSA;
  TAuxCapsW = tagAUXCAPSW;
  AUXCAPS = tagAUXCAPS;
  AUXCAPSA = tagAUXCAPSA;
  AUXCAPSW = tagAUXCAPSW;

{ flags for wTechnology field in AUXCAPS structure }
const
  AUXCAPS_CDAUDIO    = 1;       { audio from internal CD-ROM drive }
  AUXCAPS_AUXIN      = 2;       { audio from auxiliary input jacks }

{ flags for dwSupport field in AUXCAPS structure }
const
  AUXCAPS_VOLUME     = $0001;  { supports volume control }
  AUXCAPS_LRVOLUME   = $0002;  { separate left-right volume control }

{ auxiliary audio function prototypes }
function auxGetNumDevs: UINT;
function auxGetDevCaps(uDeviceID: UINT; out lpCaps: TAuxCaps; uSize: UINT): MMRESULT;
function auxGetDevCapsA(uDeviceID: UINT; out lpCaps: TAuxCapsA; uSize: UINT): MMRESULT; 
function auxGetDevCapsW(uDeviceID: UINT; out lpCaps: TAuxCapsW; uSize: UINT): MMRESULT;
function auxSetVolume(uDeviceID: UINT; dwVolume: DWORD): MMRESULT;
function auxGetVolume(uDeviceID: UINT; out lpdwVolume: DWORD): MMRESULT;
function auxOutMessage(uDeviceID, uMessage: UINT; dw1, dw2: DWORD): MMRESULT;


{****************************************************************************

			    Mixer Support

****************************************************************************}

type
  HMIXEROBJ = Integer;

  HMIXER = Integer;

const
  MIXER_SHORT_NAME_CHARS   = 16;
  MIXER_LONG_NAME_CHARS    = 64;

{ MMRESULT error return values specific to the mixer API }

  MIXERR_INVALLINE            = (MIXERR_BASE + 0);
  MIXERR_INVALCONTROL         = (MIXERR_BASE + 1);
  MIXERR_INVALVALUE           = (MIXERR_BASE + 2);
  MIXERR_LASTERROR            = (MIXERR_BASE + 2);

  MIXER_OBJECTF_HANDLE    = $80000000;
  MIXER_OBJECTF_MIXER     = $00000000;
  MIXER_OBJECTF_HMIXER    = (MIXER_OBJECTF_HANDLE or MIXER_OBJECTF_MIXER);
  MIXER_OBJECTF_WAVEOUT   = $10000000;
  MIXER_OBJECTF_HWAVEOUT  = (MIXER_OBJECTF_HANDLE or MIXER_OBJECTF_WAVEOUT);
  MIXER_OBJECTF_WAVEIN    = $20000000;
  MIXER_OBJECTF_HWAVEIN   = (MIXER_OBJECTF_HANDLE or MIXER_OBJECTF_WAVEIN);
  MIXER_OBJECTF_MIDIOUT   = $30000000;
  MIXER_OBJECTF_HMIDIOUT  = (MIXER_OBJECTF_HANDLE or MIXER_OBJECTF_MIDIOUT);
  MIXER_OBJECTF_MIDIIN    = $40000000;
  MIXER_OBJECTF_HMIDIIN   = (MIXER_OBJECTF_HANDLE or MIXER_OBJECTF_MIDIIN);
  MIXER_OBJECTF_AUX       = $50000000;

function mixerGetNumDevs: UINT;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMIXERCAPS = record
    wMid: WORD;                    { manufacturer id }
    wPid: WORD;                    { product id }
    vDriverVersion: MMVERSION;     { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;               { product name }
    fdwSupport: DWORD;             { misc. support bits }
    cDestinations: DWORD;          { count of destinations }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMIXERCAPSA = record
    wMid: WORD;                    { manufacturer id }
    wPid: WORD;                    { product id }
    vDriverVersion: MMVERSION;     { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;               { product name }
    fdwSupport: DWORD;             { misc. support bits }
    cDestinations: DWORD;          { count of destinations }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMIXERCAPSW = record
    wMid: WORD;                    { manufacturer id }
    wPid: WORD;                    { product id }
    vDriverVersion: MMVERSION;     { version of the driver }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;               { product name }
    fdwSupport: DWORD;             { misc. support bits }
    cDestinations: DWORD;          { count of destinations }
  end;
  TMixerCaps = tagMIXERCAPS;
  TMixerCapsA = tagMIXERCAPSA;
  TMixerCapsW = tagMIXERCAPSW;
  MIXERCAPS = tagMIXERCAPS;
  MIXERCAPSA = tagMIXERCAPSA;
  MIXERCAPSW = tagMIXERCAPSW;

function mixerGetDevCaps(uMxId: UINT; out pmxcaps: TMixerCaps; cbmxcaps: UINT): MMRESULT;
function mixerGetDevCapsA(uMxId: UINT; out pmxcaps: TMixerCapsA; cbmxcaps: UINT): MMRESULT;
function mixerGetDevCapsW(uMxId: UINT; out pmxcaps: TMixerCapsW; cbmxcaps: UINT): MMRESULT; 
function mixerOpen(out phmx: HMIXER; uMxId: UINT; dwCallback, dwInstance, fdwOpen: DWORD): MMRESULT;
function mixerClose(hmx: HMIXER): MMRESULT;
function mixerMessage(hmx: HMIXER; uMsg: UINT; dwParam1, dwParam2: DWORD): DWORD;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMIXERLINE = record
    cbStruct: DWORD;               { size of MIXERLINE structure }
    dwDestination: DWORD;          { zero based destination index }
    dwSource: DWORD;               { zero based source index (if source) }
    dwLineID: DWORD;               { unique line id for mixer device }
    fdwLine: DWORD;                { state/information about line }
    dwUser: DWORD;                 { driver specific information }
    dwComponentType: DWORD;        { component type line connects to }
    cChannels: DWORD;              { number of channels line supports }
    cConnections: DWORD;           { number of connections [possible] }
    cControls: DWORD;              { number of controls at this line }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_SHORT_NAME_CHARS)]
    szShortName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_LONG_NAME_CHARS)]
    szName: string;
    Target: record
      dwType: DWORD;                 { MIXERLINE_TARGETTYPE_xxxx }
      dwDeviceID: DWORD;             { target device ID of device type }
      wMid: WORD;                                   { of target device }
      wPid: WORD;                                   {      " }
      vDriverVersion: MMVERSION;                    {      " }
      [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
      szPname: string;                              {      " }
	 end;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMIXERLINEA = record
    cbStruct: DWORD;               { size of MIXERLINE structure }
    dwDestination: DWORD;          { zero based destination index }
    dwSource: DWORD;               { zero based source index (if source) }
    dwLineID: DWORD;               { unique line id for mixer device }
    fdwLine: DWORD;                { state/information about line }
    dwUser: DWORD;                 { driver specific information }
    dwComponentType: DWORD;        { component type line connects to }
    cChannels: DWORD;              { number of channels line supports }
    cConnections: DWORD;           { number of connections [possible] }
    cControls: DWORD;              { number of controls at this line }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_SHORT_NAME_CHARS)]
    szShortName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_LONG_NAME_CHARS)]
    szName: string;
    Target: record
      dwType: DWORD;                 { MIXERLINE_TARGETTYPE_xxxx }
      dwDeviceID: DWORD;             { target device ID of device type }
      wMid: WORD;                                   { of target device }
      wPid: WORD;                                   {      " }
      vDriverVersion: MMVERSION;                    {      " }
      [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
      szPname: string;                              {      " }
	 end;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMIXERLINEW = record
    cbStruct: DWORD;               { size of MIXERLINE structure }
    dwDestination: DWORD;          { zero based destination index }
    dwSource: DWORD;               { zero based source index (if source) }
    dwLineID: DWORD;               { unique line id for mixer device }
    fdwLine: DWORD;                { state/information about line }
    dwUser: DWORD;                 { driver specific information }
    dwComponentType: DWORD;        { component type line connects to }
    cChannels: DWORD;              { number of channels line supports }
    cConnections: DWORD;           { number of connections [possible] }
    cControls: DWORD;              { number of controls at this line }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_SHORT_NAME_CHARS)]
    szShortName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_LONG_NAME_CHARS)]
    szName: string;
    Target: record
      dwType: DWORD;                 { MIXERLINE_TARGETTYPE_xxxx }
      dwDeviceID: DWORD;             { target device ID of device type }
      wMid: WORD;                                   { of target device }
      wPid: WORD;                                   {      " }
      vDriverVersion: MMVERSION;                    {      " }
      [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
      szPname: string;                              {      " }
	 end;
  end;
  TMixerLine = tagMIXERLINE;
  TMixerLineA = tagMIXERLINEA;
  TMixerLineW = tagMIXERLINEW;
  MIXERLINE = tagMIXERLINE;
  MIXERLINEA = tagMIXERLINEA;
  MIXERLINEW = tagMIXERLINEW;

const
{ TMixerLine.fdwLine }

  MIXERLINE_LINEF_ACTIVE              = $00000001;
  MIXERLINE_LINEF_DISCONNECTED        = $00008000;
  MIXERLINE_LINEF_SOURCE              = $80000000;

{ TMixerLine.dwComponentType
  component types for destinations and sources }

  MIXERLINE_COMPONENTTYPE_DST_FIRST       = $00000000;
  MIXERLINE_COMPONENTTYPE_DST_UNDEFINED   = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 0);
  MIXERLINE_COMPONENTTYPE_DST_DIGITAL     = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 1);
  MIXERLINE_COMPONENTTYPE_DST_LINE        = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 2);
  MIXERLINE_COMPONENTTYPE_DST_MONITOR     = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 3);
  MIXERLINE_COMPONENTTYPE_DST_SPEAKERS    = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 4);
  MIXERLINE_COMPONENTTYPE_DST_HEADPHONES  = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 5);
  MIXERLINE_COMPONENTTYPE_DST_TELEPHONE   = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 6);
  MIXERLINE_COMPONENTTYPE_DST_WAVEIN      = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 7);
  MIXERLINE_COMPONENTTYPE_DST_VOICEIN     = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 8);
  MIXERLINE_COMPONENTTYPE_DST_LAST        = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 8);

  MIXERLINE_COMPONENTTYPE_SRC_FIRST       = $00001000;
  MIXERLINE_COMPONENTTYPE_SRC_UNDEFINED   = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 0);
  MIXERLINE_COMPONENTTYPE_SRC_DIGITAL     = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 1);
  MIXERLINE_COMPONENTTYPE_SRC_LINE        = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 2);
  MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE  = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 3);
  MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 4);
  MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 5);
  MIXERLINE_COMPONENTTYPE_SRC_TELEPHONE   = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 6);
  MIXERLINE_COMPONENTTYPE_SRC_PCSPEAKER   = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 7);
  MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT     = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 8);
  MIXERLINE_COMPONENTTYPE_SRC_AUXILIARY   = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 9);
  MIXERLINE_COMPONENTTYPE_SRC_ANALOG      = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 10);
  MIXERLINE_COMPONENTTYPE_SRC_LAST        = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 10);

{ TMixerLine.Target.dwType }

  MIXERLINE_TARGETTYPE_UNDEFINED      = 0;
  MIXERLINE_TARGETTYPE_WAVEOUT        = 1;
  MIXERLINE_TARGETTYPE_WAVEIN         = 2;
  MIXERLINE_TARGETTYPE_MIDIOUT        = 3;
  MIXERLINE_TARGETTYPE_MIDIIN         = 4;
  MIXERLINE_TARGETTYPE_AUX            = 5;

function mixerGetLineInfo(hmxobj: HMIXEROBJ; var pmxl: TMixerLine;
  fdwInfo: DWORD): MMRESULT;
function mixerGetLineInfoA(hmxobj: HMIXEROBJ; var pmxl: TMixerLineA;
  fdwInfo: DWORD): MMRESULT; 
function mixerGetLineInfoW(hmxobj: HMIXEROBJ; var pmxl: TMixerLineW;
  fdwInfo: DWORD): MMRESULT; 

const
  MIXER_GETLINEINFOF_DESTINATION      = $00000000;
  MIXER_GETLINEINFOF_SOURCE           = $00000001;
  MIXER_GETLINEINFOF_LINEID           = $00000002;
  MIXER_GETLINEINFOF_COMPONENTTYPE    = $00000003;
  MIXER_GETLINEINFOF_TARGETTYPE       = $00000004;

  MIXER_GETLINEINFOF_QUERYMASK        = $0000000F;

function mixerGetID(hmxobj: HMIXEROBJ; out puMxId: UINT; fdwId: DWORD): MMRESULT;

type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMIXERCONTROL = packed record
    cbStruct: DWORD;           { size in bytes of MIXERCONTROL }
    dwControlID: DWORD;        { unique control id for mixer device }
    dwControlType: DWORD;      { MIXERCONTROL_CONTROLTYPE_xxx }
    fdwControl: DWORD;         { MIXERCONTROL_CONTROLF_xxx }
    cMultipleItems: DWORD;     { if MIXERCONTROL_CONTROLF_MULTIPLE set }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_SHORT_NAME_CHARS)]
    szShortName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_LONG_NAME_CHARS)]
    szName: string;
    Bounds: record
      case Integer of
        0: (lMinimum, lMaximum: Longint);
        1: (dwMinimum, dwMaximum: DWORD);
        2: (dwReserved0, dwReserved1, dwReserved2,
            dwReserved3, dwReserved4, dwReserved5: DWORD);
    end;
    Metrics: record
      case Integer of
        0: (cSteps: DWORD);        { # of steps between min & max }
        1: (cbCustomData: DWORD);  { size in bytes of custom data }
        2: (dwReserved0, dwReserved1, dwReserved2,
            dwReserved3, dwReserved4, dwReserved5: DWORD);
    end;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMIXERCONTROLA = packed record
    cbStruct: DWORD;           { size in bytes of MIXERCONTROL }
    dwControlID: DWORD;        { unique control id for mixer device }
    dwControlType: DWORD;      { MIXERCONTROL_CONTROLTYPE_xxx }
    fdwControl: DWORD;         { MIXERCONTROL_CONTROLF_xxx }
    cMultipleItems: DWORD;     { if MIXERCONTROL_CONTROLF_MULTIPLE set }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_SHORT_NAME_CHARS)]
    szShortName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_LONG_NAME_CHARS)]
    szName: string;
    Bounds: record
      case Integer of
        0: (lMinimum, lMaximum: Longint);
        1: (dwMinimum, dwMaximum: DWORD);
        2: (dwReserved0, dwReserved1, dwReserved2,
            dwReserved3, dwReserved4, dwReserved5: DWORD);
    end;
    Metrics: record
      case Integer of
        0: (cSteps: DWORD);        { # of steps between min & max }
        1: (cbCustomData: DWORD);  { size in bytes of custom data }
        2: (dwReserved0, dwReserved1, dwReserved2,
            dwReserved3, dwReserved4, dwReserved5: DWORD);
    end;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMIXERCONTROLW = packed record
    cbStruct: DWORD;           { size in bytes of MIXERCONTROL }
    dwControlID: DWORD;        { unique control id for mixer device }
    dwControlType: DWORD;      { MIXERCONTROL_CONTROLTYPE_xxx }
    fdwControl: DWORD;         { MIXERCONTROL_CONTROLF_xxx }
    cMultipleItems: DWORD;     { if MIXERCONTROL_CONTROLF_MULTIPLE set }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_SHORT_NAME_CHARS)]
    szShortName: string;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_LONG_NAME_CHARS)]
    szName: string;
    Bounds: record
      case Integer of
        0: (lMinimum, lMaximum: Longint);
        1: (dwMinimum, dwMaximum: DWORD);
        2: (dwReserved0, dwReserved1, dwReserved2,
            dwReserved3, dwReserved4, dwReserved5: DWORD);
    end;
    Metrics: record
      case Integer of
        0: (cSteps: DWORD);        { # of steps between min & max }
        1: (cbCustomData: DWORD);  { size in bytes of custom data }
        2: (dwReserved0, dwReserved1, dwReserved2,
            dwReserved3, dwReserved4, dwReserved5: DWORD);
    end;
  end;  
  TMixerControl = tagMIXERCONTROL;
  TMixerControlA = tagMIXERCONTROLA;
  TMixerControlW = tagMIXERCONTROLW;
  MIXERCONTROL = tagMIXERCONTROL;
  MIXERCONTROLA = tagMIXERCONTROLA;
  MIXERCONTROLW = tagMIXERCONTROLW;

const
{ TMixerControl.fdwControl }

  MIXERCONTROL_CONTROLF_UNIFORM   = $00000001;
  MIXERCONTROL_CONTROLF_MULTIPLE  = $00000002;
  MIXERCONTROL_CONTROLF_DISABLED  = $80000000;

{ MIXERCONTROL_CONTROLTYPE_xxx building block defines }

  MIXERCONTROL_CT_CLASS_MASK          = $F0000000;
  MIXERCONTROL_CT_CLASS_CUSTOM        = $00000000;
  MIXERCONTROL_CT_CLASS_METER         = $10000000;
  MIXERCONTROL_CT_CLASS_SWITCH        = $20000000;
  MIXERCONTROL_CT_CLASS_NUMBER        = $30000000;
  MIXERCONTROL_CT_CLASS_SLIDER        = $40000000;
  MIXERCONTROL_CT_CLASS_FADER         = $50000000;
  MIXERCONTROL_CT_CLASS_TIME          = $60000000;
  MIXERCONTROL_CT_CLASS_LIST          = $70000000;

  MIXERCONTROL_CT_SUBCLASS_MASK       = $0F000000;

  MIXERCONTROL_CT_SC_SWITCH_BOOLEAN   = $00000000;
  MIXERCONTROL_CT_SC_SWITCH_BUTTON    = $01000000;

  MIXERCONTROL_CT_SC_METER_POLLED     = $00000000;

  MIXERCONTROL_CT_SC_TIME_MICROSECS   = $00000000;
  MIXERCONTROL_CT_SC_TIME_MILLISECS   = $01000000;

  MIXERCONTROL_CT_SC_LIST_SINGLE      = $00000000;
  MIXERCONTROL_CT_SC_LIST_MULTIPLE    = $01000000;

  MIXERCONTROL_CT_UNITS_MASK          = $00FF0000;
  MIXERCONTROL_CT_UNITS_CUSTOM        = $00000000;
  MIXERCONTROL_CT_UNITS_BOOLEAN       = $00010000;
  MIXERCONTROL_CT_UNITS_SIGNED        = $00020000;
  MIXERCONTROL_CT_UNITS_UNSIGNED      = $00030000;
  MIXERCONTROL_CT_UNITS_DECIBELS      = $00040000; { in 10ths }
  MIXERCONTROL_CT_UNITS_PERCENT       = $00050000; { in 10ths }

{ Commonly used control types for specifying TMixerControl.dwControlType }

  MIXERCONTROL_CONTROLTYPE_CUSTOM         = (MIXERCONTROL_CT_CLASS_CUSTOM or MIXERCONTROL_CT_UNITS_CUSTOM);
  MIXERCONTROL_CONTROLTYPE_BOOLEANMETER   = (MIXERCONTROL_CT_CLASS_METER or MIXERCONTROL_CT_SC_METER_POLLED or MIXERCONTROL_CT_UNITS_BOOLEAN);
  MIXERCONTROL_CONTROLTYPE_SIGNEDMETER    = (MIXERCONTROL_CT_CLASS_METER or MIXERCONTROL_CT_SC_METER_POLLED or MIXERCONTROL_CT_UNITS_SIGNED);
  MIXERCONTROL_CONTROLTYPE_PEAKMETER      = (MIXERCONTROL_CONTROLTYPE_SIGNEDMETER + 1);
  MIXERCONTROL_CONTROLTYPE_UNSIGNEDMETER  = (MIXERCONTROL_CT_CLASS_METER or MIXERCONTROL_CT_SC_METER_POLLED or MIXERCONTROL_CT_UNITS_UNSIGNED);
  MIXERCONTROL_CONTROLTYPE_BOOLEAN        = (MIXERCONTROL_CT_CLASS_SWITCH or MIXERCONTROL_CT_SC_SWITCH_BOOLEAN or 
    MIXERCONTROL_CT_UNITS_BOOLEAN);
  MIXERCONTROL_CONTROLTYPE_ONOFF          = (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 1);
  MIXERCONTROL_CONTROLTYPE_MUTE           = (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 2);
  MIXERCONTROL_CONTROLTYPE_MONO           = (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 3);
  MIXERCONTROL_CONTROLTYPE_LOUDNESS       = (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 4);
  MIXERCONTROL_CONTROLTYPE_STEREOENH      = (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 5);
  MIXERCONTROL_CONTROLTYPE_BUTTON         = (MIXERCONTROL_CT_CLASS_SWITCH or MIXERCONTROL_CT_SC_SWITCH_BUTTON or 
    MIXERCONTROL_CT_UNITS_BOOLEAN);
  MIXERCONTROL_CONTROLTYPE_DECIBELS       = (MIXERCONTROL_CT_CLASS_NUMBER or MIXERCONTROL_CT_UNITS_DECIBELS);
  MIXERCONTROL_CONTROLTYPE_SIGNED         = (MIXERCONTROL_CT_CLASS_NUMBER or MIXERCONTROL_CT_UNITS_SIGNED);
  MIXERCONTROL_CONTROLTYPE_UNSIGNED       = (MIXERCONTROL_CT_CLASS_NUMBER or MIXERCONTROL_CT_UNITS_UNSIGNED);
  MIXERCONTROL_CONTROLTYPE_PERCENT        = (MIXERCONTROL_CT_CLASS_NUMBER or MIXERCONTROL_CT_UNITS_PERCENT);
  MIXERCONTROL_CONTROLTYPE_SLIDER         = (MIXERCONTROL_CT_CLASS_SLIDER or MIXERCONTROL_CT_UNITS_SIGNED);
  MIXERCONTROL_CONTROLTYPE_PAN            = (MIXERCONTROL_CONTROLTYPE_SLIDER + 1);
  MIXERCONTROL_CONTROLTYPE_QSOUNDPAN      = (MIXERCONTROL_CONTROLTYPE_SLIDER + 2);
  MIXERCONTROL_CONTROLTYPE_FADER          = (MIXERCONTROL_CT_CLASS_FADER or MIXERCONTROL_CT_UNITS_UNSIGNED);
  MIXERCONTROL_CONTROLTYPE_VOLUME         = (MIXERCONTROL_CONTROLTYPE_FADER + 1);
  MIXERCONTROL_CONTROLTYPE_BASS           = (MIXERCONTROL_CONTROLTYPE_FADER + 2);
  MIXERCONTROL_CONTROLTYPE_TREBLE         = (MIXERCONTROL_CONTROLTYPE_FADER + 3);
  MIXERCONTROL_CONTROLTYPE_EQUALIZER      = (MIXERCONTROL_CONTROLTYPE_FADER + 4);
  MIXERCONTROL_CONTROLTYPE_SINGLESELECT   = (MIXERCONTROL_CT_CLASS_LIST or MIXERCONTROL_CT_SC_LIST_SINGLE or MIXERCONTROL_CT_UNITS_BOOLEAN);
  MIXERCONTROL_CONTROLTYPE_MUX            = (MIXERCONTROL_CONTROLTYPE_SINGLESELECT + 1);
  MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT = (MIXERCONTROL_CT_CLASS_LIST or MIXERCONTROL_CT_SC_LIST_MULTIPLE or MIXERCONTROL_CT_UNITS_BOOLEAN);
  MIXERCONTROL_CONTROLTYPE_MIXER          = (MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT + 1);
  MIXERCONTROL_CONTROLTYPE_MICROTIME      = (MIXERCONTROL_CT_CLASS_TIME or MIXERCONTROL_CT_SC_TIME_MICROSECS or 
    MIXERCONTROL_CT_UNITS_UNSIGNED);
  MIXERCONTROL_CONTROLTYPE_MILLITIME      = (MIXERCONTROL_CT_CLASS_TIME or MIXERCONTROL_CT_SC_TIME_MILLISECS or 
    MIXERCONTROL_CT_UNITS_UNSIGNED);


type
  [StructLayout(LayoutKind.Explicit, CharSet=CharSet.Auto)]
  tagMIXERLINECONTROLS = record
    cbStruct: DWORD;               { size in bytes of MIXERLINECONTROLS }
    dwLineID: DWORD;               { line id (from MIXERLINE.dwLineID) }
    case Integer of
      0: (dwControlID: DWORD);     { MIXER_GETLINECONTROLSF_ONEBYID }
      1: (dwControlType: DWORD;    { MIXER_GETLINECONTROLSF_ONEBYTYPE }
          cControls: DWORD;        { count of controls pmxctrl points to }
          cbmxctrl: DWORD;         { size in bytes of _one_ MIXERCONTROL }
          pamxctrl: IntPtr);       { Pointer to first MIXERCONTROL array }
  end;
  [StructLayout(LayoutKind.Explicit, CharSet=CharSet.Ansi)]
  tagMIXERLINECONTROLSA = record
    cbStruct: DWORD;               { size in bytes of MIXERLINECONTROLS }
    dwLineID: DWORD;               { line id (from MIXERLINE.dwLineID) }
    case Integer of
      0: (dwControlID: DWORD);     { MIXER_GETLINECONTROLSF_ONEBYID }
      1: (dwControlType: DWORD;    { MIXER_GETLINECONTROLSF_ONEBYTYPE }
          cControls: DWORD;        { count of controls pmxctrl points to }
          cbmxctrl: DWORD;         { size in bytes of _one_ MIXERCONTROL }
          pamxctrl: IntPtr);       { Pointer to first MIXERCONTROL array }
  end;
  [StructLayout(LayoutKind.Explicit, CharSet=CharSet.Unicode)]
  tagMIXERLINECONTROLSW = record
    cbStruct: DWORD;               { size in bytes of MIXERLINECONTROLS }
    dwLineID: DWORD;               { line id (from MIXERLINE.dwLineID) }
    case Integer of
      0: (dwControlID: DWORD);     { MIXER_GETLINECONTROLSF_ONEBYID }
      1: (dwControlType: DWORD;    { MIXER_GETLINECONTROLSF_ONEBYTYPE }
          cControls: DWORD;        { count of controls pmxctrl points to }
          cbmxctrl: DWORD;         { size in bytes of _one_ MIXERCONTROL }
          pamxctrl: IntPtr);       { Pointer to first MIXERCONTROL array }
  end;
  TMixerLineControls = tagMIXERLINECONTROLS;
  TMixerLineControlsA = tagMIXERLINECONTROLSA;
  TMixerLineControlsW = tagMIXERLINECONTROLSW;
  MIXERLINECONTROLS = tagMIXERLINECONTROLS;
  MIXERLINECONTROLSA = tagMIXERLINECONTROLSA;
  MIXERLINECONTROLSW = tagMIXERLINECONTROLSW;

function mixerGetLineControls(hmxobj: HMIXEROBJ; var pmxlc: TMixerLineControls; fdwControls: DWORD): MMRESULT;
function mixerGetLineControlsA(hmxobj: HMIXEROBJ; var pmxlc: TMixerLineControlsA; fdwControls: DWORD): MMRESULT; 
function mixerGetLineControlsW(hmxobj: HMIXEROBJ; var pmxlc: TMixerLineControlsW; fdwControls: DWORD): MMRESULT; 

const
  MIXER_GETLINECONTROLSF_ALL          = $00000000;
  MIXER_GETLINECONTROLSF_ONEBYID      = $00000001;
  MIXER_GETLINECONTROLSF_ONEBYTYPE    = $00000002;

  MIXER_GETLINECONTROLSF_QUERYMASK    = $0000000F;

type
  [StructLayout(LayoutKind.Explicit)]
  tMIXERCONTROLDETAILS = record
    cbStruct: DWORD;       { size in bytes of MIXERCONTROLDETAILS }
    dwControlID: DWORD;    { control id to get/set details on }
    cChannels: DWORD;      { number of channels in paDetails array }
    case Integer of
	   0: (hwndOwner: HWND);        { for MIXER_SETCONTROLDETAILSF_CUSTOM }
	   1: (cMultipleItems: DWORD;   { if _MULTIPLE, the number of items per channel }
	       cbDetails: DWORD;        { size of _one_ details_XX struct }
	       paDetails: IntPtr);      { pointer to array of details_XX structs }
  end;

  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMIXERCONTROLDETAILS_LISTTEXT = record
    dwParam1: DWORD;
    dwParam2: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_LONG_NAME_CHARS)]
    szName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMIXERCONTROLDETAILS_LISTTEXTA = record
    dwParam1: DWORD;
    dwParam2: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_LONG_NAME_CHARS)]
    szName: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMIXERCONTROLDETAILS_LISTTEXTW = record
    dwParam1: DWORD;
    dwParam2: DWORD;
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MIXER_LONG_NAME_CHARS)]
    szName: string;
  end;
  TMixerControlDetailsListText = tagMIXERCONTROLDETAILS_LISTTEXT;
  TMixerControlDetailsListTextA = tagMIXERCONTROLDETAILS_LISTTEXTA;
  TMixerControlDetailsListTextW = tagMIXERCONTROLDETAILS_LISTTEXTW;
  MIXERCONTROLDETAILS_LISTTEXT = tagMIXERCONTROLDETAILS_LISTTEXT;
  MIXERCONTROLDETAILS_LISTTEXTA = tagMIXERCONTROLDETAILS_LISTTEXTA;
  MIXERCONTROLDETAILS_LISTTEXTW = tagMIXERCONTROLDETAILS_LISTTEXTW;

  [StructLayout(LayoutKind.Sequential)]
  tMIXERCONTROLDETAILS_BOOLEAN = record
    fValue: Longint;
  end;
  TMixerControlDetailsBoolean = tMIXERCONTROLDETAILS_BOOLEAN;
  MIXERCONTROLDETAILS_BOOLEAN = tMIXERCONTROLDETAILS_BOOLEAN;

  [StructLayout(LayoutKind.Sequential)]
  tMIXERCONTROLDETAILS_SIGNED = record
    lValue: Longint;
  end;
  TMixerControlDetailsSigned = tMIXERCONTROLDETAILS_SIGNED;
  MIXERCONTROLDETAILS_SIGNED = tMIXERCONTROLDETAILS_SIGNED;

  [StructLayout(LayoutKind.Sequential)]
  tMIXERCONTROLDETAILS_UNSIGNED = record
    dwValue: DWORD;
  end;
  TMixerControlDetailsUnsigned = tMIXERCONTROLDETAILS_UNSIGNED;
  MIXERCONTROLDETAILS_UNSIGNED = tMIXERCONTROLDETAILS_UNSIGNED;

function mixerGetControlDetails(hmxobj: HMIXEROBJ; var pmxcd: TMixerControlDetails; fdwDetails: DWORD): MMRESULT;
function mixerGetControlDetailsA(hmxobj: HMIXEROBJ; var pmxcd: TMixerControlDetails; fdwDetails: DWORD): MMRESULT; 
function mixerGetControlDetailsW(hmxobj: HMIXEROBJ; var pmxcd: TMixerControlDetails; fdwDetails: DWORD): MMRESULT; 

const
  MIXER_GETCONTROLDETAILSF_VALUE      = $00000000;
  MIXER_GETCONTROLDETAILSF_LISTTEXT   = $00000001;

  MIXER_GETCONTROLDETAILSF_QUERYMASK  = $0000000F;

function mixerSetControlDetails(hmxobj: HMIXEROBJ; var pmxcd: TMixerControlDetails; fdwDetails: DWORD): MMRESULT;

const
  MIXER_SETCONTROLDETAILSF_VALUE      = $00000000;
  MIXER_SETCONTROLDETAILSF_CUSTOM     = $00000001;

  MIXER_SETCONTROLDETAILSF_QUERYMASK  = $0000000F;

{***************************************************************************

                            Timer support

***************************************************************************}

{ timer error return values }
const
  TIMERR_NOERROR        = 0;                  { no error }
  TIMERR_NOCANDO        = TIMERR_BASE+1;      { request not completed }
  TIMERR_STRUCT         = TIMERR_BASE+33;     { time struct size }

{ timer data types }
type
  TFNTimeCallBack = procedure(uTimerID, uMessage: UINT; 
    dwUser, dw1, dw2: DWORD);


{ flags for wFlags parameter of timeSetEvent() function }
const
  TIME_ONESHOT    = 0;   { program timer for single event }
  TIME_PERIODIC   = 1;   { program for continuous periodic event }
  TIME_CALLBACK_FUNCTION    = $0000;  { callback is function }
  TIME_CALLBACK_EVENT_SET   = $0010;  { callback is event - use SetEvent }
  TIME_CALLBACK_EVENT_PULSE = $0020;  { callback is event - use PulseEvent }

{ timer device capabilities data structure }
type
  [StructLayout(LayoutKind.Sequential)]
  timecaps_tag = record
    wPeriodMin: UINT;     { minimum period supported  }
    wPeriodMax: UINT;     { maximum period supported  }
  end;
  TTimeCaps = timecaps_tag;
  TIMECAPS = timecaps_tag;

{ timer function prototypes }
function timeGetSystemTime(out lpTime: TMMTime; uSize: Word): MMRESULT;

function timeGetTime: DWORD;
function timeSetEvent(uDelay, uResolution: UINT;
  lpFunction: TFNTimeCallBack; dwUser: DWORD; uFlags: UINT): MMRESULT;
function timeKillEvent(uTimerID: UINT): MMRESULT;
function timeGetDevCaps(out lpTimeCaps: TTimeCaps; uSize: UINT): MMRESULT;
function timeBeginPeriod(uPeriod: UINT): MMRESULT;
function timeEndPeriod(uPeriod: UINT): MMRESULT;


{***************************************************************************

                            Joystick support

***************************************************************************}

{ joystick error return values }
const
  JOYERR_NOERROR        = 0;                  { no error }
  JOYERR_PARMS          = JOYERR_BASE+5;      { bad parameters }
  JOYERR_NOCANDO        = JOYERR_BASE+6;      { request not completed }
  JOYERR_UNPLUGGED      = JOYERR_BASE+7;      { joystick is unplugged }

{ constants used with TJoyInfo and TJoyInfoEx structure and MM_JOY* messages }
const
  JOY_BUTTON1         = $0001;
  JOY_BUTTON2         = $0002;
  JOY_BUTTON3         = $0004;
  JOY_BUTTON4         = $0008;
  JOY_BUTTON1CHG      = $0100;
  JOY_BUTTON2CHG      = $0200;
  JOY_BUTTON3CHG      = $0400;
  JOY_BUTTON4CHG      = $0800;

{ constants used with TJoyInfoEx }
  JOY_BUTTON5         = $00000010;
  JOY_BUTTON6         = $00000020;
  JOY_BUTTON7         = $00000040;
  JOY_BUTTON8         = $00000080;
  JOY_BUTTON9         = $00000100;
  JOY_BUTTON10        = $00000200;
  JOY_BUTTON11        = $00000400;
  JOY_BUTTON12        = $00000800;
  JOY_BUTTON13        = $00001000;
  JOY_BUTTON14        = $00002000;
  JOY_BUTTON15        = $00004000;
  JOY_BUTTON16        = $00008000;
  JOY_BUTTON17        = $00010000;
  JOY_BUTTON18        = $00020000;
  JOY_BUTTON19        = $00040000;
  JOY_BUTTON20        = $00080000;
  JOY_BUTTON21        = $00100000;
  JOY_BUTTON22        = $00200000;
  JOY_BUTTON23        = $00400000;
  JOY_BUTTON24        = $00800000;
  JOY_BUTTON25        = $01000000;
  JOY_BUTTON26        = $02000000;
  JOY_BUTTON27        = $04000000;
  JOY_BUTTON28        = $08000000;
  JOY_BUTTON29        = $10000000;
  JOY_BUTTON30        = $20000000;
  JOY_BUTTON31        = $40000000;
  JOY_BUTTON32        = $80000000;

{ constants used with TJoyInfoEx }
  JOY_POVCENTERED	= -1;
  JOY_POVFORWARD	= 0;
  JOY_POVRIGHT		= 9000;
  JOY_POVBACKWARD	= 18000;
  JOY_POVLEFT		= 27000;

  JOY_RETURNX		= $00000001;
  JOY_RETURNY		= $00000002;
  JOY_RETURNZ		= $00000004;
  JOY_RETURNR		= $00000008;
  JOY_RETURNU		= $00000010; { axis 5 }
  JOY_RETURNV		= $00000020; { axis 6 }
  JOY_RETURNPOV		= $00000040;
  JOY_RETURNBUTTONS	= $00000080;
  JOY_RETURNRAWDATA	= $00000100;
  JOY_RETURNPOVCTS	= $00000200;
  JOY_RETURNCENTERED	= $00000400;
  JOY_USEDEADZONE		= $00000800;
  JOY_RETURNALL  = (JOY_RETURNX or JOY_RETURNY or JOY_RETURNZ or
    JOY_RETURNR or JOY_RETURNU or JOY_RETURNV or
    JOY_RETURNPOV or JOY_RETURNBUTTONS);
  JOY_CAL_READALWAYS	= $00010000;
  JOY_CAL_READXYONLY	= $00020000;
  JOY_CAL_READ3		= $00040000;
  JOY_CAL_READ4		= $00080000;
  JOY_CAL_READXONLY	= $00100000;
  JOY_CAL_READYONLY	= $00200000;
  JOY_CAL_READ5		= $00400000;
  JOY_CAL_READ6		= $00800000;
  JOY_CAL_READZONLY	= $01000000;
  JOY_CAL_READRONLY	= $02000000;
  JOY_CAL_READUONLY	= $04000000;
  JOY_CAL_READVONLY	= $08000000;

{ joystick ID constants }
const
  JOYSTICKID1         = 0;
  JOYSTICKID2         = 1;

{ joystick driver capabilites }
  JOYCAPS_HASZ		= $0001;
  JOYCAPS_HASR		= $0002;
  JOYCAPS_HASU		= $0004;
  JOYCAPS_HASV		= $0008;
  JOYCAPS_HASPOV		= $0010;
  JOYCAPS_POV4DIR		= $0020;
  JOYCAPS_POVCTS		= $0040;

{ joystick device capabilities data structure }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagJOYCAPS = record
    wMid: Word;                  { manufacturer ID }
    wPid: Word;                  { product ID }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;             { product name (NULL terminated string) }
    wXmin: UINT;                 { minimum x position value }
    wXmax: UINT;                 { maximum x position value }
    wYmin: UINT;                 { minimum y position value }
    wYmax: UINT;                 { maximum y position value }
    wZmin: UINT;                 { minimum z position value }
    wZmax: UINT;                 { maximum z position value }
    wNumButtons: UINT;           { number of buttons }
    wPeriodMin: UINT;            { minimum message period when captured }
    wPeriodMax: UINT;            { maximum message period when captured }
    wRmin: UINT;                 { minimum r position value }
    wRmax: UINT;                 { maximum r position value }
    wUmin: UINT;                 { minimum u (5th axis) position value }
    wUmax: UINT;                 { maximum u (5th axis) position value }
    wVmin: UINT;                 { minimum v (6th axis) position value }
    wVmax: UINT;                 { maximum v (6th axis) position value }
    wCaps: UINT;                 { joystick capabilites }
    wMaxAxes: UINT;	 	           { maximum number of axes supported }
    wNumAxes: UINT;	 	           { number of axes in use }
    wMaxButtons: UINT;	 	       { maximum number of buttons supported }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szRegKey: string;            { registry key }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_JOYSTICKOEMVXDNAME)]
    szOEMVxD: string;            { OEM VxD in use }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagJOYCAPSA = record
    wMid: Word;                  { manufacturer ID }
    wPid: Word;                  { product ID }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;             { product name (NULL terminated string) }
    wXmin: UINT;                 { minimum x position value }
    wXmax: UINT;                 { maximum x position value }
    wYmin: UINT;                 { minimum y position value }
    wYmax: UINT;                 { maximum y position value }
    wZmin: UINT;                 { minimum z position value }
    wZmax: UINT;                 { maximum z position value }
    wNumButtons: UINT;           { number of buttons }
    wPeriodMin: UINT;            { minimum message period when captured }
    wPeriodMax: UINT;            { maximum message period when captured }
    wRmin: UINT;                 { minimum r position value }
    wRmax: UINT;                 { maximum r position value }
    wUmin: UINT;                 { minimum u (5th axis) position value }
    wUmax: UINT;                 { maximum u (5th axis) position value }
    wVmin: UINT;                 { minimum v (6th axis) position value }
    wVmax: UINT;                 { maximum v (6th axis) position value }
    wCaps: UINT;                 { joystick capabilites }
    wMaxAxes: UINT;	 	           { maximum number of axes supported }
    wNumAxes: UINT;	 	           { number of axes in use }
    wMaxButtons: UINT;	 	       { maximum number of buttons supported }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szRegKey: string;            { registry key }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_JOYSTICKOEMVXDNAME)]
    szOEMVxD: string;            { OEM VxD in use }
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagJOYCAPSW = record
    wMid: Word;                  { manufacturer ID }
    wPid: Word;                  { product ID }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szPname: string;             { product name (NULL terminated string) }
    wXmin: UINT;                 { minimum x position value }
    wXmax: UINT;                 { maximum x position value }
    wYmin: UINT;                 { minimum y position value }
    wYmax: UINT;                 { maximum y position value }
    wZmin: UINT;                 { minimum z position value }
    wZmax: UINT;                 { maximum z position value }
    wNumButtons: UINT;           { number of buttons }
    wPeriodMin: UINT;            { minimum message period when captured }
    wPeriodMax: UINT;            { maximum message period when captured }
    wRmin: UINT;                 { minimum r position value }
    wRmax: UINT;                 { maximum r position value }
    wUmin: UINT;                 { minimum u (5th axis) position value }
    wUmax: UINT;                 { maximum u (5th axis) position value }
    wVmin: UINT;                 { minimum v (6th axis) position value }
    wVmax: UINT;                 { maximum v (6th axis) position value }
    wCaps: UINT;                 { joystick capabilites }
    wMaxAxes: UINT;	 	           { maximum number of axes supported }
    wNumAxes: UINT;	 	           { number of axes in use }
    wMaxButtons: UINT;	 	       { maximum number of buttons supported }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAXPNAMELEN)]
    szRegKey: string;            { registry key }
    [MarshalAs(UnmanagedType.ByValTStr, SizeConst=MAX_JOYSTICKOEMVXDNAME)]
    szOEMVxD: string;            { OEM VxD in use }
  end;
  TJoyCaps = tagJOYCAPS;
  TJoyCapsA = tagJOYCAPSA;
  TJoyCapsW = tagJOYCAPSW;
  JOYCAPS = tagJOYCAPS;
  JOYCAPSA = tagJOYCAPSA;
  JOYCAPSW = tagJOYCAPSW;

{ joystick information data structure }
type
  [StructLayout(LayoutKind.Sequential)]
  joyinfo_tag = record
    wXpos: UINT;                 { x position }
    wYpos: UINT;                 { y position }
    wZpos: UINT;                 { z position }
    wButtons: UINT;              { button states }
  end;
  TJoyInfo = joyinfo_tag;
  JOYINFO = joyinfo_tag;

  [StructLayout(LayoutKind.Sequential)]
  joyinfoex_tag = record
    dwSize: DWORD;		 { size of structure }
    dwFlags: DWORD;		 { flags to indicate what to return }
    wXpos: UINT;         { x position }
    wYpos: UINT;         { y position }
    wZpos: UINT;         { z position }
    dwRpos: DWORD;		 { rudder/4th axis position }
    dwUpos: DWORD;		 { 5th axis position }
    dwVpos: DWORD;		 { 6th axis position }
    wButtons: UINT;      { button states }
    dwButtonNumber: DWORD;  { current button number pressed }
    dwPOV: DWORD;           { point of view state }
    dwReserved1: DWORD;		 { reserved for communication between winmm & driver }
    dwReserved2: DWORD;		 { reserved for future expansion }
  end;
  TJoyInfoEx = joyinfoex_tag;
  JOYINFOEX = joyinfoex_tag;

{ joystick function prototypes }
function joyGetNumDevs: UINT;
function joyGetDevCaps(uJoyID: UINT; out lpCaps: TJoyCaps; uSize: UINT): MMRESULT;
function joyGetDevCapsA(uJoyID: UINT; out lpCaps: TJoyCapsA; uSize: UINT): MMRESULT; 
function joyGetDevCapsW(uJoyID: UINT; out lpCaps: TJoyCapsW; uSize: UINT): MMRESULT;
function joyGetPos(uJoyID: UINT; out lpInfo: TJoyInfo): MMRESULT;
function joyGetPosEx(uJoyID: UINT; var lpInfo: TJoyInfoEx): MMRESULT;
function joyGetThreshold(uJoyID: UINT; out lpuThreshold: UINT): MMRESULT;
function joyReleaseCapture(uJoyID: UINT): MMRESULT;
function joySetCapture(Handle: HWND; uJoyID, uPeriod: UINT; bChanged: BOOL): MMRESULT;
function joySetThreshold(uJoyID, uThreshold: UINT): MMRESULT;

{***************************************************************************

                        Multimedia File I/O support

***************************************************************************}

{ MMIO error return values }
const
  MMIOERR_BASE            = 256;
  MMIOERR_FILENOTFOUND    = MMIOERR_BASE + 1;  { file not found }
  MMIOERR_OUTOFMEMORY     = MMIOERR_BASE + 2;  { out of memory }
  MMIOERR_CANNOTOPEN      = MMIOERR_BASE + 3;  { cannot open }
  MMIOERR_CANNOTCLOSE     = MMIOERR_BASE + 4;  { cannot close }
  MMIOERR_CANNOTREAD      = MMIOERR_BASE + 5;  { cannot read }
  MMIOERR_CANNOTWRITE     = MMIOERR_BASE + 6;  { cannot write }
  MMIOERR_CANNOTSEEK      = MMIOERR_BASE + 7;  { cannot seek }
  MMIOERR_CANNOTEXPAND    = MMIOERR_BASE + 8;  { cannot expand file }
  MMIOERR_CHUNKNOTFOUND   = MMIOERR_BASE + 9;  { chunk not found }
  MMIOERR_UNBUFFERED      = MMIOERR_BASE + 10; { file is unbuffered }
  MMIOERR_PATHNOTFOUND        = MMIOERR_BASE + 11;  { path incorrect }
  MMIOERR_ACCESSDENIED        = MMIOERR_BASE + 12;  { file was protected }
  MMIOERR_SHARINGVIOLATION    = MMIOERR_BASE + 13;  { file in use }
  MMIOERR_NETWORKERROR        = MMIOERR_BASE + 14;  { network not responding }
  MMIOERR_TOOMANYOPENFILES    = MMIOERR_BASE + 15;  { no more file handles  }
  MMIOERR_INVALIDFILE         = MMIOERR_BASE + 16;  { default error file error }

{ MMIO constants }
const
  CFSEPCHAR       = '+';             { compound file name separator char. }

type
{ MMIO data types }
  FOURCC = DWORD;                    { a four character code }

  HMMIO = Integer;      { a handle to an open file }

{ general MMIO information data structure }
type
  [StructLayout(LayoutKind.Sequential)]
  _MMIOINFO = record
    { general fields }
    dwFlags: DWORD;        { general status flags }
    fccIOProc: FOURCC;     { pointer to I/O procedure }
    pIOProc: IntPtr;       { pointer to TFNMMIOProc I/O procedure }
    wErrorRet: UINT;       { place for error to be returned }
    hTask: HTASK;          { alternate local task }

    { fields maintained by MMIO functions during buffered I/O }
    cchBuffer: Longint;    { size of I/O buffer (or 0L) }
    pchBuffer: IntPtr;     { start of I/O buffer (or NULL) }
    pchNext: IntPtr;       { pointer to next byte to read/write }
    pchEndRead: IntPtr;    { pointer to last valid byte to read }
    pchEndWrite: IntPtr;   { pointer to last byte to write }
    lBufOffset: Longint;   { disk offset of start of buffer }

    { fields maintained by I/O procedure }
    lDiskOffset: Longint;    { disk offset of next read or write }
    adwInfo: array[0..2] of DWORD;     { data specific to type of MMIOPROC }

    { other fields maintained by MMIO }
    dwReserved1: DWORD;    { reserved for MMIO use }
    dwReserved2: DWORD;    { reserved for MMIO use }
    hmmio: HMMIO;          { handle to open file }
  end;
  TMMIOInfo = _MMIOINFO;
  MMIOINFO = _MMIOINFO;

  TFNMMIOProc = function(var lpmmioinfo: TMMIOInfo; uMessage: UINT; lParam1, lParam2: LPARAM): Longint;

{ RIFF chunk information data structure }
type
  [StructLayout(LayoutKind.Sequential)]
  _MMCKINFO = record
    ckid: FOURCC;           { chunk ID }
    cksize: DWORD;         { chunk size }
    fccType: FOURCC;        { form type or list type }
    dwDataOffset: DWORD;   { offset of data portion of chunk }
    dwFlags: DWORD;        { flags used by MMIO functions }
  end;
  TMMCKInfo = _MMCKINFO;
  MMCKINFO = _MMCKINFO;

{ bit field masks }
const
  MMIO_RWMODE     = $00000003;      { open file for reading/writing/both }
  MMIO_SHAREMODE  = $00000070;      { file sharing mode number }

{ constants for dwFlags field of MMIOINFO }
const
  MMIO_CREATE    = $00001000;     { create new file (or truncate file) }
  MMIO_PARSE     = $00000100;     { parse new file returning path }
  MMIO_DELETE    = $00000200;     { create new file (or truncate file) }
  MMIO_EXIST     = $00004000;     { checks for existence of file }
  MMIO_ALLOCBUF  = $00010000;     { mmioOpen() should allocate a buffer }
  MMIO_GETTEMP   = $00020000;     { mmioOpen() should retrieve temp name }

const
  MMIO_DIRTY     = $10000000;     { I/O buffer is dirty }

{ read/write mode numbers (bit field MMIO_RWMODE) }
const
  MMIO_READ       = $00000000;      { open file for reading only }
  MMIO_WRITE      = $00000001;      { open file for writing only }
  MMIO_READWRITE  = $00000002;      { open file for reading and writing }

{ share mode numbers (bit field MMIO_SHAREMODE) }
const
  MMIO_COMPAT     = $00000000;      { compatibility mode }
  MMIO_EXCLUSIVE  = $00000010;      { exclusive-access mode }
  MMIO_DENYWRITE  = $00000020;      { deny writing to other processes }
  MMIO_DENYREAD   = $00000030;      { deny reading to other processes }
  MMIO_DENYNONE   = $00000040;      { deny nothing to other processes }

{ various MMIO flags }
const
  MMIO_FHOPEN             = $0010;  { mmioClose: keep file handle open }
  MMIO_EMPTYBUF           = $0010;  { mmioFlush: empty the I/O buffer }
  MMIO_TOUPPER            = $0010;  { mmioStringToFOURCC: to u-case }
  MMIO_INSTALLPROC    = $00010000;  { mmioInstallIOProc: install MMIOProc }
  MMIO_GLOBALPROC     = $10000000;  { mmioInstallIOProc: install globally }
  MMIO_REMOVEPROC     = $00020000;  { mmioInstallIOProc: remove MMIOProc }
  MMIO_UNICODEPROC    = $01000000;  { mmioInstallIOProc: Unicode MMIOProc }
  MMIO_FINDPROC       = $00040000;  { mmioInstallIOProc: find an MMIOProc }
  MMIO_FINDCHUNK          = $0010;  { mmioDescend: find a chunk by ID }
  MMIO_FINDRIFF           = $0020;  { mmioDescend: find a LIST chunk }
  MMIO_FINDLIST           = $0040;  { mmioDescend: find a RIFF chunk }
  MMIO_CREATERIFF         = $0020;  { mmioCreateChunk: make a LIST chunk }
  MMIO_CREATELIST         = $0040;  { mmioCreateChunk: make a RIFF chunk }


{ message numbers for MMIOPROC I/O procedure functions }
const
  MMIOM_READ      = MMIO_READ;       { read }
  MMIOM_WRITE    = MMIO_WRITE;       { write }
  MMIOM_SEEK              = 2;       { seek to a new position in file }
  MMIOM_OPEN              = 3;       { open file }
  MMIOM_CLOSE             = 4;       { close file }
  MMIOM_WRITEFLUSH        = 5;       { write and flush }

const
  MMIOM_RENAME            = 6;       { rename specified file }

  MMIOM_USER         = $8000;       { beginning of user-defined messages }

{ standard four character codes }
const
  FOURCC_RIFF = $46464952;   { 'RIFF' }
  FOURCC_LIST = $5453494C;   { 'LIST' }

{ four character codes used to identify standard built-in I/O procedures }
const
  FOURCC_DOS  = $20532F44;   { 'DOS '}
  FOURCC_MEM  = $204D454D;   { 'MEM '}

{ flags for mmioSeek() }
const
  SEEK_SET        = 0;               { seek to an absolute position }
  SEEK_CUR        = 1;               { seek relative to current position }
  SEEK_END        = 2;               { seek relative to end of file }

{ other constants }
const
  MMIO_DEFAULTBUFFER      = 8192;    { default buffer size }

{ MMIO function prototypes }
function mmioStringToFOURCC(sz: string; uFlags: UINT): FOURCC;
function mmioStringToFOURCCA(sz: string; uFlags: UINT): FOURCC; 
function mmioStringToFOURCCW(sz: string; uFlags: UINT): FOURCC; 
function mmioInstallIOProc(fccIOProc: FOURCC; pIOProc: TFNMMIOProc;
  dwFlags: DWORD): TFNMMIOProc;
function mmioInstallIOProcA(fccIOProc: FOURCC; pIOProc: TFNMMIOProc;
  dwFlags: DWORD): TFNMMIOProc; 
function mmioInstallIOProcW(fccIOProc: FOURCC; pIOProc: TFNMMIOProc;
  dwFlags: DWORD): TFNMMIOProc; 
function mmioOpen(szFileName: string; const lpmmioinfo: TMMIOInfo;
  dwOpenFlags: DWORD): HMMIO; overload;
function mmioOpen(szFileName: IntPtr; const lpmmioinfo: TMMIOInfo;
  dwOpenFlags: DWORD): HMMIO; overload;
function mmioOpen(szFileName: string; lpmmioinfo: IntPtr;
  dwOpenFlags: DWORD): HMMIO; overload;
function mmioOpen(szFileName, lpmmioinfo: IntPtr;
  dwOpenFlags: DWORD): HMMIO; overload;
function mmioOpenA(szFileName: string; const lpmmioinfo: TMMIOInfo;
  dwOpenFlags: DWORD): HMMIO;
function mmioOpenW(szFileName: string; const lpmmioinfo: TMMIOInfo;
  dwOpenFlags: DWORD): HMMIO;
function mmioRename(szFileName, szNewFileName: string;
  const lpmmioinfo: TMMIOInfo; dwRenameFlags: DWORD): MMRESULT;
function mmioRenameA(szFileName, szNewFileName: string;
  const lpmmioinfo: TMMIOInfo; dwRenameFlags: DWORD): MMRESULT;
function mmioRenameW(szFileName, szNewFileName: string;
  const lpmmioinfo: TMMIOInfo; dwRenameFlags: DWORD): MMRESULT;
function mmioClose(hmmio: HMMIO; uFlags: UINT): MMRESULT;
function mmioRead(hmmio: HMMIO; [out] pch: TBytes; cch: Longint): Longint;
function mmioWrite(hmmio: HMMIO; [in] pch: TBytes; cch: Longint): Longint;
function mmioSeek(hmmio: HMMIO; lOffset: Longint;
  iOrigin: Integer): Longint;
function mmioGetInfo(hmmio: HMMIO; var lpmmioinfo: TMMIOInfo; uFlags: UINT): MMRESULT;
function mmioSetInfo(hmmio: HMMIO; const lpmmioinfo: TMMIOInfo; uFlags: UINT): MMRESULT;
function mmioSetBuffer(hmmio: HMMIO; pchBuffer: TBytes; cchBuffer: Longint;
  uFlags: Word): MMRESULT; overload;
function mmioSetBuffer(hmmio: HMMIO; pchBuffer: IntPtr; cchBuffer: Longint;
  uFlags: Word): MMRESULT; overload;
function mmioFlush(hmmio: HMMIO; uFlags: UINT): MMRESULT;
function mmioAdvance(hmmio: HMMIO; var lpmmioinfo: TMMIOInfo; uFlags: UINT): MMRESULT;
function mmioSendMessage(hmmio: HMMIO; uMessage: UINT;
  lParam1, lParam2: DWORD): Longint;
function mmioDescend(hmmio: HMMIO; var lpck: TMMCKInfo;
  var lpckParent: TMMCKInfo; uFlags: UINT): MMRESULT; overload;
function mmioDescend(hmmio: HMMIO; var lpck: TMMCKInfo;
  lpckParent: IntPtr; uFlags: UINT): MMRESULT; overload;
function mmioAscend(hmmio: HMMIO; const lpck: TMMCKInfo; uFlags: UINT): MMRESULT;
function mmioCreateChunk(hmmio: HMMIO; var lpck: TMMCKInfo; uFlags: UINT): MMRESULT;


{***************************************************************************

                            MCI support

***************************************************************************}

type
  MCIERROR = DWORD;     { error return code, 0 means no error }
  MCIDEVICEID = UINT;   { MCI device ID type }

  TFNYieldProc = function(mciId: MCIDEVICEID; dwYieldData: DWORD): UINT;

  { generic parameter block for MCI command messages with no special parameters }
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_GENERIC_PARMS = record
    dwCallback: DWORD;
  end;
  TMCI_Generic_Parms = tagMCI_GENERIC_PARMS;
  MCI_GENERIC_PARMS = tagMCI_GENERIC_PARMS;

  { parameter block for MCI_OPEN command message }
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMCI_OPEN_PARMS = record
    dwCallback: DWORD;
    wDeviceID: MCIDEVICEID;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrDeviceType: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrElementName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrAlias: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMCI_OPEN_PARMSA = record
    dwCallback: DWORD;
    wDeviceID: MCIDEVICEID;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrDeviceType: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrElementName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrAlias: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMCI_OPEN_PARMSW = record
    dwCallback: DWORD;
    wDeviceID: MCIDEVICEID;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrDeviceType: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrElementName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrAlias: string;
  end;
  TMCI_Open_Parms = tagMCI_OPEN_PARMS;
  TMCI_Open_ParmsA = tagMCI_OPEN_PARMSA;
  TMCI_Open_ParmsW = tagMCI_OPEN_PARMSW;
  MCI_OPEN_PARMS = tagMCI_OPEN_PARMS;
  MCI_OPEN_PARMSA = tagMCI_OPEN_PARMSA;
  MCI_OPEN_PARMSW = tagMCI_OPEN_PARMSW;

  { parameter block for MCI_PLAY command message }
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_PLAY_PARMS = record
    dwCallback: DWORD;
    dwFrom: DWORD;
    dwTo: DWORD;
  end;
  TMCI_Play_Parms = tagMCI_PLAY_PARMS;
  MCI_PLAY_PARMS = tagMCI_PLAY_PARMS;

  { parameter block for MCI_SEEK command message }
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_SEEK_PARMS = record
    dwCallback: DWORD;
    dwTo: DWORD;
  end;
  TMCI_Seek_Parms = tagMCI_SEEK_PARMS;
  MCI_SEEK_PARMS = tagMCI_SEEK_PARMS;

  { parameter block for MCI_RECORD command message }
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_RECORD_PARMS = record
    dwCallback: DWORD;
    dwFrom: DWORD;
    dwTo: DWORD;
  end;
  TMCI_Record_Parms = tagMCI_RECORD_PARMS;
  MCI_RECORD_PARMS = tagMCI_RECORD_PARMS;

  { parameter block for MCI_STEP command message }
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_ANIM_STEP_PARMS = record
    dwCallback: DWORD;
    dwFrames: DWORD;
  end;
  TMCI_Anim_Step_Parms = tagMCI_ANIM_STEP_PARMS;
  MCI_ANIM_STEP_PARMS = tagMCI_ANIM_STEP_PARMS;

  { parameter block for MCI_WINDOW command message }
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMCI_ANIM_WINDOW_PARMS = record
    dwCallback: DWORD;
    Wnd: HWND;  { formerly "hWnd" }
    nCmdShow: UINT;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrText: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMCI_ANIM_WINDOW_PARMSA = record
    dwCallback: DWORD;
    Wnd: HWND;  { formerly "hWnd" }
    nCmdShow: UINT;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrText: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMCI_ANIM_WINDOW_PARMSW = record
    dwCallback: DWORD;
    Wnd: HWND;  { formerly "hWnd" }
    nCmdShow: UINT;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrText: string;
  end;
  TMCI_Anim_Window_Parms = tagMCI_ANIM_WINDOW_PARMS;
  TMCI_Anim_Window_ParmsA = tagMCI_ANIM_WINDOW_PARMSA;
  TMCI_Anim_Window_ParmsW = tagMCI_ANIM_WINDOW_PARMSW;
  MCI_ANIM_WINDOW_PARMS = tagMCI_ANIM_WINDOW_PARMS;
  MCI_ANIM_WINDOW_PARMSA = tagMCI_ANIM_WINDOW_PARMSA;
  MCI_ANIM_WINDOW_PARMSW = tagMCI_ANIM_WINDOW_PARMSW;

  { parameter block for MCI_PUT, MCI_UPDATE, MCI_WHERE command messages }
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_ANIM_RECT_PARMS = record
    dwCallback: DWORD;
    rc: TRect;
  end;
  TMCI_Anim_Rect_Parms = tagMCI_ANIM_RECT_PARMS;
  MCI_ANIM_RECT_PARMS = tagMCI_ANIM_RECT_PARMS;

  { parameter block for MCI_SET command message }
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_SET_PARMS = record
    dwCallback: DWORD;
    dwTimeFormat: DWORD;
    dwAudio: DWORD;
  end;
  TMCI_Set_Parms = tagMCI_SET_PARMS;
  MCI_SET_PARMS = tagMCI_SET_PARMS;

  { parameter block for MCI_STATUS command message }
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_STATUS_PARMS = record
    dwCallback: DWORD;
    dwReturn: DWORD;
    dwItem: DWORD;
    dwTrack: DWORD;
  end;
  TMCI_Status_Parms = tagMCI_STATUS_PARMS;
  MCI_STATUS_PARMS = tagMCI_STATUS_PARMS;

  { parameter block for MCI_SAVE command message }
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  MCI_SAVE_PARMS = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpfilename: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  MCI_SAVE_PARMSA = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpfilename: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  MCI_SAVE_PARMSW = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpfilename: string;
  end;
  TMCI_SaveParms = MCI_SAVE_PARMS;
  TMCI_SaveParmsA = MCI_SAVE_PARMSA;
  TMCI_SaveParmsW = MCI_SAVE_PARMSW;

  { parameter block for MCI_GETDEVCAPS command message }
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_GETDEVCAPS_PARMS = record
    dwCallback: DWORD;
    dwReturn: DWORD;
    dwItem: DWORD;
  end;
  TMCI_GetDevCaps_Parms = tagMCI_GETDEVCAPS_PARMS;
  MCI_GETDEVCAPS_PARMS = tagMCI_GETDEVCAPS_PARMS;

{ MCI function prototypes }
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; dwParam2: IntPtr): MCIERROR; overload;
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Generic_Parms): MCIERROR; overload;
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Open_Parms): MCIERROR; overload;
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Play_Parms): MCIERROR; overload;
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Record_Parms): MCIERROR; overload;
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Seek_Parms): MCIERROR; overload;
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Anim_Step_Parms): MCIERROR; overload;
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Set_Parms): MCIERROR; overload;
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Status_Parms): MCIERROR; overload;
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_SaveParms): MCIERROR; overload;
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Anim_Window_Parms): MCIERROR; overload;
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Anim_Rect_Parms): MCIERROR; overload;
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_GetDevCaps_Parms): MCIERROR; overload;
function mciSendCommandA(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; dwParam2: IntPtr): MCIERROR;
function mciSendCommandW(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; dwParam2: IntPtr): MCIERROR;

function mciSendString(lpstrCommand: string; lpstrReturnString: StringBuilder;
  uReturnLength: UINT; hWndCallback: HWND): MCIERROR;
function mciSendStringA(lpstrCommand: string; lpstrReturnString: StringBuilder;
  uReturnLength: UINT; hWndCallback: HWND): MCIERROR; 
function mciSendStringW(lpstrCommand: string; lpstrReturnString: StringBuilder;
  uReturnLength: UINT; hWndCallback: HWND): MCIERROR; 
function mciGetDeviceID(pszDevice: string): MCIDEVICEID;
function mciGetDeviceIDA(pszDevice: string): MCIDEVICEID; 
function mciGetDeviceIDW(pszDevice: string): MCIDEVICEID;
function mciGetDeviceIDFromElementID(dwElementID: DWORD; lpstrType: string): MCIDEVICEID;
function mciGetDeviceIDFromElementIDA(dwElementID: DWORD; lpstrType: string): MCIDEVICEID; 
function mciGetDeviceIDFromElementIDW(dwElementID: DWORD; lpstrType: string): MCIDEVICEID; 
function mciGetErrorString(mcierr: MCIERROR; pszText: StringBuilder; uLength: UINT): BOOL;
function mciGetErrorStringA(mcierr: MCIERROR; pszText: StringBuilder; uLength: UINT): BOOL; 
function mciGetErrorStringW(mcierr: MCIERROR; pszText: StringBuilder; uLength: UINT): BOOL; 
function mciSetYieldProc(mciId: MCIDEVICEID; fpYieldProc: TFNYieldProc;
  dwYieldData: DWORD): BOOL;
function mciGetCreatorTask(mciId: MCIDEVICEID): HTASK;
function mciGetYieldProc(mciId: MCIDEVICEID; var lpdwYieldData: DWORD): TFNYieldProc;
function mciExecute(pszCommand: string): BOOL;


{ MCI error return values }
const
  MCIERR_INVALID_DEVICE_ID        = MCIERR_BASE + 1;
  MCIERR_UNRECOGNIZED_KEYWORD     = MCIERR_BASE + 3;
  MCIERR_UNRECOGNIZED_COMMAND     = MCIERR_BASE + 5;
  MCIERR_HARDWARE                 = MCIERR_BASE + 6;
  MCIERR_INVALID_DEVICE_NAME      = MCIERR_BASE + 7;
  MCIERR_OUT_OF_MEMORY            = MCIERR_BASE + 8;
  MCIERR_DEVICE_OPEN              = MCIERR_BASE + 9;
  MCIERR_CANNOT_LOAD_DRIVER       = MCIERR_BASE + 10;
  MCIERR_MISSING_COMMAND_STRING   = MCIERR_BASE + 11;
  MCIERR_PARAM_OVERFLOW           = MCIERR_BASE + 12;
  MCIERR_MISSING_STRING_ARGUMENT  = MCIERR_BASE + 13;
  MCIERR_BAD_INTEGER              = MCIERR_BASE + 14;
  MCIERR_PARSER_INTERNAL          = MCIERR_BASE + 15;
  MCIERR_DRIVER_INTERNAL          = MCIERR_BASE + 16;
  MCIERR_MISSING_PARAMETER        = MCIERR_BASE + 17;
  MCIERR_UNSUPPORTED_FUNCTION     = MCIERR_BASE + 18;
  MCIERR_FILE_NOT_FOUND           = MCIERR_BASE + 19;
  MCIERR_DEVICE_NOT_READY         = MCIERR_BASE + 20;
  MCIERR_INTERNAL                 = MCIERR_BASE + 21;
  MCIERR_DRIVER                   = MCIERR_BASE + 22;
  MCIERR_CANNOT_USE_ALL           = MCIERR_BASE + 23;
  MCIERR_MULTIPLE                 = MCIERR_BASE + 24;
  MCIERR_EXTENSION_NOT_FOUND      = MCIERR_BASE + 25;
  MCIERR_OUTOFRANGE               = MCIERR_BASE + 26;
  MCIERR_FLAGS_NOT_COMPATIBLE     = MCIERR_BASE + 28;
  MCIERR_FILE_NOT_SAVED           = MCIERR_BASE + 30;
  MCIERR_DEVICE_TYPE_REQUIRED     = MCIERR_BASE + 31;
  MCIERR_DEVICE_LOCKED            = MCIERR_BASE + 32;
  MCIERR_DUPLICATE_ALIAS          = MCIERR_BASE + 33;
  MCIERR_BAD_CONSTANT             = MCIERR_BASE + 34;
  MCIERR_MUST_USE_SHAREABLE       = MCIERR_BASE + 35;
  MCIERR_MISSING_DEVICE_NAME      = MCIERR_BASE + 36;
  MCIERR_BAD_TIME_FORMAT          = MCIERR_BASE + 37;
  MCIERR_NO_CLOSING_QUOTE         = MCIERR_BASE + 38;
  MCIERR_DUPLICATE_FLAGS          = MCIERR_BASE + 39;
  MCIERR_INVALID_FILE             = MCIERR_BASE + 40;
  MCIERR_NULL_PARAMETER_BLOCK     = MCIERR_BASE + 41;
  MCIERR_UNNAMED_RESOURCE         = MCIERR_BASE + 42;
  MCIERR_NEW_REQUIRES_ALIAS       = MCIERR_BASE + 43;
  MCIERR_NOTIFY_ON_AUTO_OPEN      = MCIERR_BASE + 44;
  MCIERR_NO_ELEMENT_ALLOWED       = MCIERR_BASE + 45;
  MCIERR_NONAPPLICABLE_FUNCTION   = MCIERR_BASE + 46;
  MCIERR_ILLEGAL_FOR_AUTO_OPEN    = MCIERR_BASE + 47;
  MCIERR_FILENAME_REQUIRED        = MCIERR_BASE + 48;
  MCIERR_EXTRA_CHARACTERS         = MCIERR_BASE + 49;
  MCIERR_DEVICE_NOT_INSTALLED     = MCIERR_BASE + 50;
  MCIERR_GET_CD                   = MCIERR_BASE + 51;
  MCIERR_SET_CD                   = MCIERR_BASE + 52;
  MCIERR_SET_DRIVE                = MCIERR_BASE + 53;
  MCIERR_DEVICE_LENGTH            = MCIERR_BASE + 54;
  MCIERR_DEVICE_ORD_LENGTH        = MCIERR_BASE + 55;
  MCIERR_NO_INTEGER               = MCIERR_BASE + 56;

const
  MCIERR_WAVE_OUTPUTSINUSE        = MCIERR_BASE + 64;
  MCIERR_WAVE_SETOUTPUTINUSE      = MCIERR_BASE + 65;
  MCIERR_WAVE_INPUTSINUSE         = MCIERR_BASE + 66;
  MCIERR_WAVE_SETINPUTINUSE       = MCIERR_BASE + 67;
  MCIERR_WAVE_OUTPUTUNSPECIFIED   = MCIERR_BASE + 68;
  MCIERR_WAVE_INPUTUNSPECIFIED    = MCIERR_BASE + 69;
  MCIERR_WAVE_OUTPUTSUNSUITABLE   = MCIERR_BASE + 70;
  MCIERR_WAVE_SETOUTPUTUNSUITABLE = MCIERR_BASE + 71;
  MCIERR_WAVE_INPUTSUNSUITABLE    = MCIERR_BASE + 72;
  MCIERR_WAVE_SETINPUTUNSUITABLE  = MCIERR_BASE + 73;

  MCIERR_SEQ_DIV_INCOMPATIBLE     = MCIERR_BASE + 80;
  MCIERR_SEQ_PORT_INUSE           = MCIERR_BASE + 81;
  MCIERR_SEQ_PORT_NONEXISTENT     = MCIERR_BASE + 82;
  MCIERR_SEQ_PORT_MAPNODEVICE     = MCIERR_BASE + 83;
  MCIERR_SEQ_PORT_MISCERROR       = MCIERR_BASE + 84;
  MCIERR_SEQ_TIMER                = MCIERR_BASE + 85;
  MCIERR_SEQ_PORTUNSPECIFIED      = MCIERR_BASE + 86;
  MCIERR_SEQ_NOMIDIPRESENT        = MCIERR_BASE + 87;

  MCIERR_NO_WINDOW                = MCIERR_BASE + 90;
  MCIERR_CREATEWINDOW             = MCIERR_BASE + 91;
  MCIERR_FILE_READ                = MCIERR_BASE + 92;
  MCIERR_FILE_WRITE               = MCIERR_BASE + 93;

  MCIERR_NO_IDENTITY              = MCIERR_BASE + 94;

{ all custom device driver errors must be >= this value }
const
  MCIERR_CUSTOM_DRIVER_BASE       = mcierr_Base + 256;

{ MCI command message identifiers }
const
  MCI_OPEN       = $0803;
  MCI_CLOSE      = $0804;
  MCI_ESCAPE     = $0805;
  MCI_PLAY       = $0806;
  MCI_SEEK       = $0807;
  MCI_STOP       = $0808;
  MCI_PAUSE      = $0809;
  MCI_INFO       = $080A;
  MCI_GETDEVCAPS = $080B;
  MCI_SPIN       = $080C;
  MCI_SET        = $080D;
  MCI_STEP       = $080E;
  MCI_RECORD     = $080F;
  MCI_SYSINFO    = $0810;
  MCI_BREAK      = $0811;
  MCI_SOUND      = $0812;
  MCI_SAVE       = $0813;
  MCI_STATUS     = $0814;
  MCI_CUE        = $0830;
  MCI_REALIZE    = $0840;
  MCI_WINDOW     = $0841;
  MCI_PUT        = $0842;
  MCI_WHERE      = $0843;
  MCI_FREEZE     = $0844;
  MCI_UNFREEZE   = $0845;
  MCI_LOAD       = $0850;
  MCI_CUT        = $0851;
  MCI_COPY       = $0852;
  MCI_PASTE      = $0853;
  MCI_UPDATE     = $0854;
  MCI_RESUME     = $0855;
  MCI_DELETE     = $0856;

{ all custom MCI command messages must be >= this value }
const
  MCI_USER_MESSAGES               = $400 + drv_MCI_First;
  MCI_LAST                        = $0FFF;

{ device ID for "all devices" }
const
  MCI_ALL_DEVICE_ID               = UINT(-1);

{ constants for predefined MCI device types }
const
  MCI_DEVTYPE_VCR                 = MCI_STRING_OFFSET + 1;
  MCI_DEVTYPE_VIDEODISC           = MCI_STRING_OFFSET + 2;
  MCI_DEVTYPE_OVERLAY             = MCI_STRING_OFFSET + 3;
  MCI_DEVTYPE_CD_AUDIO            = MCI_STRING_OFFSET + 4;
  MCI_DEVTYPE_DAT                 = MCI_STRING_OFFSET + 5;
  MCI_DEVTYPE_SCANNER             = MCI_STRING_OFFSET + 6;
  MCI_DEVTYPE_ANIMATION           = MCI_STRING_OFFSET + 7;
  MCI_DEVTYPE_DIGITAL_VIDEO       = MCI_STRING_OFFSET + 8;
  MCI_DEVTYPE_OTHER               = MCI_STRING_OFFSET + 9;
  MCI_DEVTYPE_WAVEFORM_AUDIO      = MCI_STRING_OFFSET + 10;
  MCI_DEVTYPE_SEQUENCER           = MCI_STRING_OFFSET + 11;

  MCI_DEVTYPE_FIRST              = MCI_DEVTYPE_VCR;
  MCI_DEVTYPE_LAST               = MCI_DEVTYPE_SEQUENCER;

  MCI_DEVTYPE_FIRST_USER         = 1000;

{ return values for 'status mode' command }
const
  MCI_MODE_NOT_READY              = MCI_STRING_OFFSET + 12;
  MCI_MODE_STOP                   = MCI_STRING_OFFSET + 13;
  MCI_MODE_PLAY                   = MCI_STRING_OFFSET + 14;
  MCI_MODE_RECORD                 = MCI_STRING_OFFSET + 15;
  MCI_MODE_SEEK                   = MCI_STRING_OFFSET + 16;
  MCI_MODE_PAUSE                  = MCI_STRING_OFFSET + 17;
  MCI_MODE_OPEN                   = MCI_STRING_OFFSET + 18;

{ constants used in 'set time format' and 'status time format' commands }
const
  MCI_FORMAT_MILLISECONDS         = 0;
  MCI_FORMAT_HMS                  = 1;
  MCI_FORMAT_MSF                  = 2;
  MCI_FORMAT_FRAMES               = 3;
  MCI_FORMAT_SMPTE_24             = 4;
  MCI_FORMAT_SMPTE_25             = 5;
  MCI_FORMAT_SMPTE_30             = 6;
  MCI_FORMAT_SMPTE_30DROP         = 7;
  MCI_FORMAT_BYTES                = 8;
  MCI_FORMAT_SAMPLES              = 9;
  MCI_FORMAT_TMSF                 = 10;

{ MCI time format conversion macros }

function mci_MSF_Minute(msf: Longint): Byte;
function mci_MSF_Second(msf: Longint): Byte;
function mci_MSF_Frame(msf: Longint): Byte;
function mci_Make_MSF(m, s, f: Byte): Longint;
function mci_TMSF_Track(tmsf: Longint): Byte;
function mci_TMSF_Minute(tmsf: Longint): Byte;
function mci_TMSF_Second(tmsf: Longint): Byte;
function mci_TMSF_Frame(tmsf: Longint): Byte;
function mci_Make_TMSF(t, m, s, f: Byte): Longint;
function mci_HMS_Hour(hms: Longint): Byte;
function mci_HMS_Minute(hms: Longint): Byte;
function mci_HMS_Second(hms: Longint): Byte;
function mci_Make_HMS(h, m, s: Byte): Longint;

{ flags for wParam of MM_MCINOTIFY message }
const
  MCI_NOTIFY_SUCCESSFUL           = $0001;
  MCI_NOTIFY_SUPERSEDED           = $0002;
  MCI_NOTIFY_ABORTED              = $0004;
  MCI_NOTIFY_FAILURE              = $0008;

{ common flags for dwFlags parameter of MCI command messages }
const
  MCI_NOTIFY                      = $00000001;
  MCI_WAIT                        = $00000002;
  MCI_FROM                        = $00000004;
  MCI_TO                          = $00000008;
  MCI_TRACK                       = $00000010;

{ flags for dwFlags parameter of MCI_OPEN command message }
const
  MCI_OPEN_SHAREABLE              = $00000100;
  MCI_OPEN_ELEMENT                = $00000200;
  MCI_OPEN_ALIAS                  = $00000400;
  MCI_OPEN_ELEMENT_ID             = $00000800;
  MCI_OPEN_TYPE_ID                = $00001000;
  MCI_OPEN_TYPE                   = $00002000;

{ flags for dwFlags parameter of MCI_SEEK command message }
const
  MCI_SEEK_TO_START               = $00000100;
  MCI_SEEK_TO_END                 = $00000200;

{ flags for dwFlags parameter of MCI_STATUS command message }
const
  MCI_STATUS_ITEM                 = $00000100;
  MCI_STATUS_START                = $00000200;

{ flags for dwItem field of the MCI_STATUS_PARMS parameter block }
const
  MCI_STATUS_LENGTH               = $00000001;
  MCI_STATUS_POSITION             = $00000002;
  MCI_STATUS_NUMBER_OF_TRACKS     = $00000003;
  MCI_STATUS_MODE                 = $00000004;
  MCI_STATUS_MEDIA_PRESENT        = $00000005;
  MCI_STATUS_TIME_FORMAT          = $00000006;
  MCI_STATUS_READY                = $00000007;
  MCI_STATUS_CURRENT_TRACK        = $00000008;

{ flags for dwFlags parameter of MCI_INFO command message }
const
  MCI_INFO_PRODUCT                = $00000100;
  MCI_INFO_FILE                   = $00000200;
  MCI_INFO_MEDIA_UPC              = $00000400;
  MCI_INFO_MEDIA_IDENTITY         = $00000800;
  MCI_INFO_NAME                   = $00001000;
  MCI_INFO_COPYRIGHT              = $00002000;

{ flags for dwFlags parameter of MCI_GETDEVCAPS command message }
const
  MCI_GETDEVCAPS_ITEM             = $00000100;

{ flags for dwItem field of the MCI_GETDEVCAPS_PARMS parameter block }
const
  MCI_GETDEVCAPS_CAN_RECORD       = $00000001;
  MCI_GETDEVCAPS_HAS_AUDIO        = $00000002;
  MCI_GETDEVCAPS_HAS_VIDEO        = $00000003;
  MCI_GETDEVCAPS_DEVICE_TYPE      = $00000004;
  MCI_GETDEVCAPS_USES_FILES       = $00000005;
  MCI_GETDEVCAPS_COMPOUND_DEVICE  = $00000006;
  MCI_GETDEVCAPS_CAN_EJECT        = $00000007;
  MCI_GETDEVCAPS_CAN_PLAY         = $00000008;
  MCI_GETDEVCAPS_CAN_SAVE         = $00000009;

{ flags for dwFlags parameter of MCI_SYSINFO command message }
const
  MCI_SYSINFO_QUANTITY            = $00000100;
  MCI_SYSINFO_OPEN                = $00000200;
  MCI_SYSINFO_NAME                = $00000400;
  MCI_SYSINFO_INSTALLNAME         = $00000800;

{ flags for dwFlags parameter of MCI_SET command message }
const
  MCI_SET_DOOR_OPEN               = $00000100;
  MCI_SET_DOOR_CLOSED             = $00000200;
  MCI_SET_TIME_FORMAT             = $00000400;
  MCI_SET_AUDIO                   = $00000800;
  MCI_SET_VIDEO                   = $00001000;
  MCI_SET_ON                      = $00002000;
  MCI_SET_OFF                     = $00004000;

{ flags for dwAudio field of MCI_SET_PARMS or MCI_SEQ_SET_PARMS }
const
  MCI_SET_AUDIO_ALL               = $00000000;
  MCI_SET_AUDIO_LEFT              = $00000001;
  MCI_SET_AUDIO_RIGHT             = $00000002;

{ flags for dwFlags parameter of MCI_BREAK command message }
const
  MCI_BREAK_KEY                   = $00000100;
  MCI_BREAK_HWND                  = $00000200;
  MCI_BREAK_OFF                   = $00000400;

{ flags for dwFlags parameter of MCI_RECORD command message }
const
  MCI_RECORD_INSERT               = $00000100;
  MCI_RECORD_OVERWRITE            = $00000200;

{ flags for dwFlags parameter of MCI_SOUND command message }
const
  MCI_SOUND_NAME                  = $00000100;

{ flags for dwFlags parameter of MCI_SAVE command message }
const
  MCI_SAVE_FILE                   = $00000100;

{ flags for dwFlags parameter of MCI_LOAD command message }
const
  MCI_LOAD_FILE                   = $00000100;

{ parameter block for MCI_INFO command message }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMCI_INFO_PARMS = record
    dwCallback: DWORD;
    lpstrReturn: IntPtr;
    dwRetSize: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMCI_INFO_PARMSA = record
    dwCallback: DWORD;
    lpstrReturn: IntPtr;
    dwRetSize: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMCI_INFO_PARMSW = record
    dwCallback: DWORD;
    lpstrReturn: IntPtr;
    dwRetSize: DWORD;
  end;
  TMCI_Info_Parms = tagMCI_INFO_PARMS;
  TMCI_Info_ParmsA = tagMCI_INFO_PARMSA;
  TMCI_Info_ParmsW = tagMCI_INFO_PARMSW;
  MCI_INFO_PARMS = tagMCI_INFO_PARMS;
  MCI_INFO_PARMSA = tagMCI_INFO_PARMSA;
  MCI_INFO_PARMSW = tagMCI_INFO_PARMSW;

{ parameter block for MCI_SYSINFO command message }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMCI_SYSINFO_PARMS = record
    dwCallback: DWORD;
    lpstrReturn: IntPtr;
    dwRetSize: DWORD;
    dwNumber: DWORD;
    wDeviceType: UINT;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMCI_SYSINFO_PARMSA = record
    dwCallback: DWORD;
    lpstrReturn: IntPtr;
    dwRetSize: DWORD;
    dwNumber: DWORD;
    wDeviceType: UINT;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMCI_SYSINFO_PARMSW = record
    dwCallback: DWORD;
    lpstrReturn: IntPtr;
    dwRetSize: DWORD;
    dwNumber: DWORD;
    wDeviceType: UINT;
  end;
  TMCI_SysInfo_Parms = tagMCI_SYSINFO_PARMS;
  TMCI_SysInfo_ParmsA = tagMCI_SYSINFO_PARMSA;
  TMCI_SysInfo_ParmsW = tagMCI_SYSINFO_PARMSW;
  MCI_SYSINFO_PARMS = tagMCI_SYSINFO_PARMS;
  MCI_SYSINFO_PARMSA = tagMCI_SYSINFO_PARMSA;
  MCI_SYSINFO_PARMSW = tagMCI_SYSINFO_PARMSW;

{ parameter block for MCI_BREAK command message }
type
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_BREAK_PARMS = record
    dwCallback: DWORD;
    nVirtKey: Integer;
    hWndBreak: HWND;
  end;
  TMCI_BReak_Parms = tagMCI_BREAK_PARMS;
  MCI_BREAK_PARMS = tagMCI_BREAK_PARMS;

{ parameter block for MCI_SOUND command message }
type
  [StructLayout(LayoutKind.Sequential)]
  TMCI_Sound_Parms = record
    dwCallback: Longint;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrSoundName: string;
  end;

{ parameter block for MCI_LOAD command message }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMCI_LOAD_PARMS = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpfilename: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMCI_LOAD_PARMSA = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpfilename: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMCI_LOAD_PARMSW = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpfilename: string;
  end;
  TMCI_Load_Parms = tagMCI_LOAD_PARMS;
  TMCI_Load_ParmsA = tagMCI_LOAD_PARMSA;
  TMCI_Load_ParmsW = tagMCI_LOAD_PARMSW;
  MCI_LOAD_PARMS = tagMCI_LOAD_PARMS;
  MCI_LOAD_PARMSA = tagMCI_LOAD_PARMSA;
  MCI_LOAD_PARMSW = tagMCI_LOAD_PARMSW;

{ MCI extensions for videodisc devices }

{ flag for dwReturn field of MCI_STATUS_PARMS }
{ MCI_STATUS command, (dwItem == MCI_STATUS_MODE) }
const
  MCI_VD_MODE_PARK                = MCI_VD_OFFSET + 1;

{ flag for dwReturn field of MCI_STATUS_PARMS }
{ MCI_STATUS command, (dwItem == MCI_VD_STATUS_MEDIA_TYPE) }
const
  MCI_VD_MEDIA_CLV                = MCI_VD_OFFSET + 2;
  MCI_VD_MEDIA_CAV                = MCI_VD_OFFSET + 3;
  MCI_VD_MEDIA_OTHER              = MCI_VD_OFFSET + 4;

const
  MCI_VD_FORMAT_TRACK             = $4001;

{ flags for dwFlags parameter of MCI_PLAY command message }
const
  MCI_VD_PLAY_REVERSE             = $00010000;
  MCI_VD_PLAY_FAST                = $00020000;
  MCI_VD_PLAY_SPEED               = $00040000;
  MCI_VD_PLAY_SCAN                = $00080000;
  MCI_VD_PLAY_SLOW                = $00100000;

{ flag for dwFlags parameter of MCI_SEEK command message }
const
  MCI_VD_SEEK_REVERSE             = $00010000;

{ flags for dwItem field of MCI_STATUS_PARMS parameter block }
const
  MCI_VD_STATUS_SPEED             = $00004002;
  MCI_VD_STATUS_FORWARD           = $00004003;
  MCI_VD_STATUS_MEDIA_TYPE        = $00004004;
  MCI_VD_STATUS_SIDE              = $00004005;
  MCI_VD_STATUS_DISC_SIZE         = $00004006;

{ flags for dwFlags parameter of MCI_GETDEVCAPS command message }
const
  MCI_VD_GETDEVCAPS_CLV           = $00010000;
  MCI_VD_GETDEVCAPS_CAV           = $00020000;

  MCI_VD_SPIN_UP                  = $00010000;
  MCI_VD_SPIN_DOWN                = $00020000;

{ flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block }
const
  MCI_VD_GETDEVCAPS_CAN_REVERSE   = $00004002;
  MCI_VD_GETDEVCAPS_FAST_RATE     = $00004003;
  MCI_VD_GETDEVCAPS_SLOW_RATE     = $00004004;
  MCI_VD_GETDEVCAPS_NORMAL_RATE   = $00004005;

{ flags for the dwFlags parameter of MCI_STEP command message }
const
  MCI_VD_STEP_FRAMES              = $00010000;
  MCI_VD_STEP_REVERSE             = $00020000;

{ flag for the MCI_ESCAPE command message }
const
  MCI_VD_ESCAPE_STRING            = $00000100;

{ parameter block for MCI_PLAY command message }
type
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_VD_PLAY_PARMS = record
    dwCallback: DWORD;
    dwFrom: DWORD;
    dwTo: DWORD;
    dwSpeed: DWORD;
  end;
  TMCI_VD_Play_Parms = tagMCI_VD_PLAY_PARMS;
  MCI_VD_PLAY_PARMS = tagMCI_VD_PLAY_PARMS;

{ parameter block for MCI_STEP command message }
type
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_VD_STEP_PARMS = record
    dwCallback: DWORD;
    dwFrames: DWORD;
  end;
  TMCI_VD_Step_Parms = tagMCI_VD_STEP_PARMS;
  MCI_VD_STEP_PARMS = tagMCI_VD_STEP_PARMS;

{ parameter block for MCI_ESCAPE command message }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMCI_VD_ESCAPE_PARMS = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrCommand: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMCI_VD_ESCAPE_PARMSA = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrCommand: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMCI_VD_ESCAPE_PARMSW = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrCommand: string;
  end;
  TMCI_VD_Escape_Parms = tagMCI_VD_ESCAPE_PARMS;
  TMCI_VD_Escape_ParmsA = tagMCI_VD_ESCAPE_PARMSA;
  TMCI_VD_Escape_ParmsW = tagMCI_VD_ESCAPE_PARMSW;
  MCI_VD_ESCAPE_PARMS = tagMCI_VD_ESCAPE_PARMS;
  MCI_VD_ESCAPE_PARMSA = tagMCI_VD_ESCAPE_PARMSA;
  MCI_VD_ESCAPE_PARMSW = tagMCI_VD_ESCAPE_PARMSW;

{ MCI extensions for CD audio devices }

{ flags for the dwItem field of the MCI_STATUS_PARMS parameter block }
const
  MCI_CDA_STATUS_TYPE_TRACK       = $00004001;

{ flags for the dwReturn field of MCI_STATUS_PARMS parameter block }
{ MCI_STATUS command, (dwItem == MCI_CDA_STATUS_TYPE_TRACK) }
  MCI_CDA_TRACK_AUDIO             = MCI_CD_OFFSET + 0;
  MCI_CDA_TRACK_OTHER             = MCI_CD_OFFSET + 1;

{ MCI extensions for waveform audio devices }
  MCI_WAVE_PCM                    = MCI_WAVE_OFFSET + 0;
  MCI_WAVE_MAPPER                 = MCI_WAVE_OFFSET + 1;

{ flags for the dwFlags parameter of MCI_OPEN command message }
const
  MCI_WAVE_OPEN_BUFFER            = $00010000;

{ flags for the dwFlags parameter of MCI_SET command message }
const
  MCI_WAVE_SET_FORMATTAG          = $00010000;
  MCI_WAVE_SET_CHANNELS           = $00020000;
  MCI_WAVE_SET_SAMPLESPERSEC      = $00040000;
  MCI_WAVE_SET_AVGBYTESPERSEC     = $00080000;
  MCI_WAVE_SET_BLOCKALIGN         = $00100000;
  MCI_WAVE_SET_BITSPERSAMPLE      = $00200000;

{ flags for the dwFlags parameter of MCI_STATUS, MCI_SET command messages }
const
  MCI_WAVE_INPUT                  = $00400000;
  MCI_WAVE_OUTPUT                 = $00800000;

{ flags for the dwItem field of MCI_STATUS_PARMS parameter block }
const
  MCI_WAVE_STATUS_FORMATTAG       = $00004001;
  MCI_WAVE_STATUS_CHANNELS        = $00004002;
  MCI_WAVE_STATUS_SAMPLESPERSEC   = $00004003;
  MCI_WAVE_STATUS_AVGBYTESPERSEC  = $00004004;
  MCI_WAVE_STATUS_BLOCKALIGN      = $00004005;
  MCI_WAVE_STATUS_BITSPERSAMPLE   = $00004006;
  MCI_WAVE_STATUS_LEVEL           = $00004007;

{ flags for the dwFlags parameter of MCI_SET command message }
const
  MCI_WAVE_SET_ANYINPUT           = $04000000;
  MCI_WAVE_SET_ANYOUTPUT          = $08000000;

{ flags for the dwFlags parameter of MCI_GETDEVCAPS command message }
const
  MCI_WAVE_GETDEVCAPS_INPUTS      = $00004001;
  MCI_WAVE_GETDEVCAPS_OUTPUTS     = $00004002;

{ parameter block for MCI_OPEN command message }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMCI_WAVE_OPEN_PARMS = record
    dwCallback: DWORD;
    wDeviceID: MCIDEVICEID;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrDeviceType: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrElementName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrAlias: string;
    dwBufferSeconds: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMCI_WAVE_OPEN_PARMSA = record
    dwCallback: DWORD;
    wDeviceID: MCIDEVICEID;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrDeviceType: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrElementName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrAlias: string;
    dwBufferSeconds: DWORD;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMCI_WAVE_OPEN_PARMSW = record
    dwCallback: DWORD;
    wDeviceID: MCIDEVICEID;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrDeviceType: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrElementName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrAlias: string;
    dwBufferSeconds: DWORD;
  end;
  TMCI_Wave_Open_Parms = tagMCI_WAVE_OPEN_PARMS;
  TMCI_Wave_Open_ParmsA = tagMCI_WAVE_OPEN_PARMSA;
  TMCI_Wave_Open_ParmsW = tagMCI_WAVE_OPEN_PARMSW;
  MCI_WAVE_OPEN_PARMS = tagMCI_WAVE_OPEN_PARMS;
  MCI_WAVE_OPEN_PARMSA = tagMCI_WAVE_OPEN_PARMSA;
  MCI_WAVE_OPEN_PARMSW = tagMCI_WAVE_OPEN_PARMSW;

{ parameter block for MCI_DELETE command message }
type
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_WAVE_DELETE_PARMS = record
    dwCallback: DWORD;
    dwFrom: DWORD;
    dwTo: DWORD;
  end;
  TMCI_Wave_Delete_Parms = tagMCI_WAVE_DELETE_PARMS;
  MCI_WAVE_DELETE_PARMS = tagMCI_WAVE_DELETE_PARMS;

{ parameter block for MCI_SET command message }
type
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_WAVE_SET_PARMS = record
    dwCallback: DWORD;
    dwTimeFormat: DWORD;
    dwAudio: DWORD;
    wInput: UINT;
    wOutput: UINT;
    wFormatTag: Word;
    wReserved2: Word;
    nChannels: Word;
    wReserved3: Word;
    nSamplesPerSec: DWORD;
    nAvgBytesPerSec: DWORD;
    nBlockAlign: Word;
    wReserved4: Word;
    wBitsPerSample: Word;
    wReserved5: Word;
  end;
  TMCI_Wave_Set_Parms = tagMCI_WAVE_SET_PARMS;
  MCI_WAVE_SET_PARMS = tagMCI_WAVE_SET_PARMS;


{ MCI extensions for MIDI sequencer devices }

{ flags for the dwReturn field of MCI_STATUS_PARMS parameter block }
{ MCI_STATUS command, (dwItem == MCI_SEQ_STATUS_DIVTYPE) }
const
  MCI_SEQ_DIV_PPQN            = 0 + MCI_SEQ_OFFSET;
  MCI_SEQ_DIV_SMPTE_24        = 1 + MCI_SEQ_OFFSET;
  MCI_SEQ_DIV_SMPTE_25        = 2 + MCI_SEQ_OFFSET;
  MCI_SEQ_DIV_SMPTE_30DROP    = 3 + MCI_SEQ_OFFSET;
  MCI_SEQ_DIV_SMPTE_30        = 4 + MCI_SEQ_OFFSET;

{ flags for the dwMaster field of MCI_SEQ_SET_PARMS parameter block }
{ MCI_SET command, (dwFlags == MCI_SEQ_SET_MASTER) }
const
  MCI_SEQ_FORMAT_SONGPTR      = $4001;
  MCI_SEQ_FILE                = $4002;
  MCI_SEQ_MIDI                = $4003;
  MCI_SEQ_SMPTE               = $4004;
  MCI_SEQ_NONE                = 65533;
  MCI_SEQ_MAPPER              = 65535;

{ flags for the dwItem field of MCI_STATUS_PARMS parameter block }
const
  MCI_SEQ_STATUS_TEMPO            = $00004002;
  MCI_SEQ_STATUS_PORT             = $00004003;
  MCI_SEQ_STATUS_SLAVE            = $00004007;
  MCI_SEQ_STATUS_MASTER           = $00004008;
  MCI_SEQ_STATUS_OFFSET           = $00004009;
  MCI_SEQ_STATUS_DIVTYPE          = $0000400A;
  MCI_SEQ_STATUS_NAME             = $0000400B;
  MCI_SEQ_STATUS_COPYRIGHT        = $0000400C;

{ flags for the dwFlags parameter of MCI_SET command message }
const
  MCI_SEQ_SET_TEMPO               = $00010000;
  MCI_SEQ_SET_PORT                = $00020000;
  MCI_SEQ_SET_SLAVE               = $00040000;
  MCI_SEQ_SET_MASTER              = $00080000;
  MCI_SEQ_SET_OFFSET              = $01000000;

{ parameter block for MCI_SET command message }
type
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_SEQ_SET_PARMS = record
    dwCallback: DWORD;
    dwTimeFormat: DWORD;
    dwAudio: DWORD;
    dwTempo: DWORD;
    dwPort: DWORD;
    dwSlave: DWORD;
    dwMaster: DWORD;
    dwOffset: DWORD;
  end;
  TMCI_Seq_Set_Parms = tagMCI_SEQ_SET_PARMS;
  MCI_SEQ_SET_PARMS = tagMCI_SEQ_SET_PARMS;

{ MCI extensions for animation devices }

{ flags for dwFlags parameter of MCI_OPEN command message }
const
  MCI_ANIM_OPEN_WS                = $00010000;
  MCI_ANIM_OPEN_PARENT            = $00020000;
  MCI_ANIM_OPEN_NOSTATIC          = $00040000;

{ flags for dwFlags parameter of MCI_PLAY command message }
const
  MCI_ANIM_PLAY_SPEED             = $00010000;
  MCI_ANIM_PLAY_REVERSE           = $00020000;
  MCI_ANIM_PLAY_FAST              = $00040000;
  MCI_ANIM_PLAY_SLOW              = $00080000;
  MCI_ANIM_PLAY_SCAN              = $00100000;

{ flags for dwFlags parameter of MCI_STEP command message }
const
  MCI_ANIM_STEP_REVERSE           = $00010000;
  MCI_ANIM_STEP_FRAMES            = $00020000;

{ flags for dwItem field of MCI_STATUS_PARMS parameter block }
const
  MCI_ANIM_STATUS_SPEED           = $00004001;
  MCI_ANIM_STATUS_FORWARD         = $00004002;
  MCI_ANIM_STATUS_HWND            = $00004003;
  MCI_ANIM_STATUS_HPAL            = $00004004;
  MCI_ANIM_STATUS_STRETCH         = $00004005;

{ flags for the dwFlags parameter of MCI_INFO command message }
const
  MCI_ANIM_INFO_TEXT              = $00010000;

{ flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block }
const
  MCI_ANIM_GETDEVCAPS_CAN_REVERSE = $00004001;
  MCI_ANIM_GETDEVCAPS_FAST_RATE   = $00004002;
  MCI_ANIM_GETDEVCAPS_SLOW_RATE   = $00004003;
  MCI_ANIM_GETDEVCAPS_NORMAL_RATE = $00004004;
  MCI_ANIM_GETDEVCAPS_PALETTES    = $00004006;
  MCI_ANIM_GETDEVCAPS_CAN_STRETCH = $00004007;
  MCI_ANIM_GETDEVCAPS_MAX_WINDOWS = $00004008;

{ flags for the MCI_REALIZE command message }
const
  MCI_ANIM_REALIZE_NORM           = $00010000;
  MCI_ANIM_REALIZE_BKGD           = $00020000;

{ flags for dwFlags parameter of MCI_WINDOW command message }
const
  MCI_ANIM_WINDOW_HWND            = $00010000;
  MCI_ANIM_WINDOW_STATE           = $00040000;
  MCI_ANIM_WINDOW_TEXT            = $00080000;
  MCI_ANIM_WINDOW_ENABLE_STRETCH  = $00100000;
  MCI_ANIM_WINDOW_DISABLE_STRETCH = $00200000;

{ flags for hWnd field of MCI_ANIM_WINDOW_PARMS parameter block }
{ MCI_WINDOW command message, (dwFlags == MCI_ANIM_WINDOW_HWND) }
const
  MCI_ANIM_WINDOW_DEFAULT         = $00000000;

{ flags for dwFlags parameter of MCI_PUT command message }
const
  MCI_ANIM_RECT                   = $00010000;
  MCI_ANIM_PUT_SOURCE             = $00020000;
  MCI_ANIM_PUT_DESTINATION        = $00040000;

{ flags for dwFlags parameter of MCI_WHERE command message }
const
  MCI_ANIM_WHERE_SOURCE           = $00020000;
  MCI_ANIM_WHERE_DESTINATION      = $00040000;

{ flags for dwFlags parameter of MCI_UPDATE command message }
const
  MCI_ANIM_UPDATE_HDC             = $00020000;

{ parameter block for MCI_OPEN command message }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMCI_ANIM_OPEN_PARMS = record
    dwCallback: DWORD;
    wDeviceID: MCIDEVICEID;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrDeviceType: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrElementName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrAlias: string;
    dwStyle: DWORD;
    hWndParent: HWND;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMCI_ANIM_OPEN_PARMSA = record
    dwCallback: DWORD;
    wDeviceID: MCIDEVICEID;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrDeviceType: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrElementName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrAlias: string;
    dwStyle: DWORD;
    hWndParent: HWND;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMCI_ANIM_OPEN_PARMSW = record
    dwCallback: DWORD;
    wDeviceID: MCIDEVICEID;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrDeviceType: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrElementName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrAlias: string;
    dwStyle: DWORD;
    hWndParent: HWND;
  end;
  TMCI_Anim_Open_Parms = tagMCI_ANIM_OPEN_PARMS;
  TMCI_Anim_Open_ParmsA = tagMCI_ANIM_OPEN_PARMSA;
  TMCI_Anim_Open_ParmsW = tagMCI_ANIM_OPEN_PARMSW;
  MCI_ANIM_OPEN_PARMS = tagMCI_ANIM_OPEN_PARMS;
  MCI_ANIM_OPEN_PARMSA = tagMCI_ANIM_OPEN_PARMSA;
  MCI_ANIM_OPEN_PARMSW = tagMCI_ANIM_OPEN_PARMSW;

{ parameter block for MCI_PLAY command message }
type
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_ANIM_PLAY_PARMS = record
    dwCallback: DWORD;
    dwFrom: DWORD;
    dwTo: DWORD;
    dwSpeed: DWORD;
  end;
  TMCI_Anim_Play_Parms = tagMCI_ANIM_PLAY_PARMS;
  MCI_ANIM_PLAY_PARMS = tagMCI_ANIM_PLAY_PARMS;

{ parameter block for MCI_UPDATE PARMS }
type
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_ANIM_UPDATE_PARMS = record
    dwCallback: DWORD;
    rc: TRect;
    hDC: HDC;
  end;
  TMCI_Anim_Update_Parms = tagMCI_ANIM_UPDATE_PARMS;
  MCI_ANIM_UPDATE_PARMS = tagMCI_ANIM_UPDATE_PARMS;

{ MCI extensions for video overlay devices }

{ flags for dwFlags parameter of MCI_OPEN command message }
const
  MCI_OVLY_OPEN_WS                = $00010000;
  MCI_OVLY_OPEN_PARENT            = $00020000;

{ flags for dwFlags parameter of MCI_STATUS command message }
const
  MCI_OVLY_STATUS_HWND            = $00004001;
  MCI_OVLY_STATUS_STRETCH         = $00004002;

{ flags for dwFlags parameter of MCI_INFO command message }
const
  MCI_OVLY_INFO_TEXT              = $00010000;

{ flags for dwItem field of MCI_GETDEVCAPS_PARMS parameter block }
const
  MCI_OVLY_GETDEVCAPS_CAN_STRETCH = $00004001;
  MCI_OVLY_GETDEVCAPS_CAN_FREEZE  = $00004002;
  MCI_OVLY_GETDEVCAPS_MAX_WINDOWS = $00004003;

{ flags for dwFlags parameter of MCI_WINDOW command message }
const
  MCI_OVLY_WINDOW_HWND            = $00010000;
  MCI_OVLY_WINDOW_STATE           = $00040000;
  MCI_OVLY_WINDOW_TEXT            = $00080000;
  MCI_OVLY_WINDOW_ENABLE_STRETCH  = $00100000;
  MCI_OVLY_WINDOW_DISABLE_STRETCH = $00200000;

{ flags for hWnd parameter of MCI_OVLY_WINDOW_PARMS parameter block }
const
  MCI_OVLY_WINDOW_DEFAULT         = $00000000;

{ flags for dwFlags parameter of MCI_PUT command message }
const
  MCI_OVLY_RECT                   = $00010000;
  MCI_OVLY_PUT_SOURCE             = $00020000;
  MCI_OVLY_PUT_DESTINATION        = $00040000;
  MCI_OVLY_PUT_FRAME              = $00080000;
  MCI_OVLY_PUT_VIDEO              = $00100000;

{ flags for dwFlags parameter of MCI_WHERE command message }
const
  MCI_OVLY_WHERE_SOURCE           = $00020000;
  MCI_OVLY_WHERE_DESTINATION      = $00040000;
  MCI_OVLY_WHERE_FRAME            = $00080000;
  MCI_OVLY_WHERE_VIDEO            = $00100000;

{ parameter block for MCI_OPEN command message }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMCI_OVLY_OPEN_PARMS = record
    dwCallback: DWORD;
    wDeviceID: MCIDEVICEID;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrDeviceType: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrElementName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrAlias: string;
    dwStyle: DWORD;
    hWndParent: HWND;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMCI_OVLY_OPEN_PARMSA = record
    dwCallback: DWORD;
    wDeviceID: MCIDEVICEID;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrDeviceType: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrElementName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrAlias: string;
    dwStyle: DWORD;
    hWndParent: HWND;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMCI_OVLY_OPEN_PARMSW = record
    dwCallback: DWORD;
    wDeviceID: MCIDEVICEID;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrDeviceType: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrElementName: string;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrAlias: string;
    dwStyle: DWORD;
    hWndParent: HWND;
  end;
  TMCI_Ovly_Open_Parms = tagMCI_OVLY_OPEN_PARMS;
  TMCI_Ovly_Open_ParmsA = tagMCI_OVLY_OPEN_PARMSA;
  TMCI_Ovly_Open_ParmsW = tagMCI_OVLY_OPEN_PARMSW;
  MCI_OVLY_OPEN_PARMS = tagMCI_OVLY_OPEN_PARMS;
  MCI_OVLY_OPEN_PARMSA = tagMCI_OVLY_OPEN_PARMSA;
  MCI_OVLY_OPEN_PARMSW = tagMCI_OVLY_OPEN_PARMSW;

{ parameter block for MCI_WINDOW command message }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMCI_OVLY_WINDOW_PARMS = record
    dwCallback: DWORD;
    WHandle: HWND; { formerly "hWnd"}
    nCmdShow: UINT;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrText: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMCI_OVLY_WINDOW_PARMSA = record
    dwCallback: DWORD;
    WHandle: HWND; { formerly "hWnd"}
    nCmdShow: UINT;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrText: string;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMCI_OVLY_WINDOW_PARMSW = record
    dwCallback: DWORD;
    WHandle: HWND; { formerly "hWnd"}
    nCmdShow: UINT;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpstrText: string;
  end;
  TMCI_Ovly_Window_Parms = tagMCI_OVLY_WINDOW_PARMS;
  TMCI_Ovly_Window_ParmsA = tagMCI_OVLY_WINDOW_PARMSA;
  TMCI_Ovly_Window_ParmsW = tagMCI_OVLY_WINDOW_PARMSW;
  MCI_OVLY_WINDOW_PARMS = tagMCI_OVLY_WINDOW_PARMS;
  MCI_OVLY_WINDOW_PARMSA = tagMCI_OVLY_WINDOW_PARMSA;
  MCI_OVLY_WINDOW_PARMSW = tagMCI_OVLY_WINDOW_PARMSW;

{ parameter block for MCI_PUT, MCI_UPDATE, and MCI_WHERE command messages }
type
  [StructLayout(LayoutKind.Sequential)]
  tagMCI_OVLY_RECT_PARMS = record
    dwCallback: DWORD;
    rc: TRect;
  end;
  TMCI_Ovly_Rect_Parms = tagMCI_OVLY_RECT_PARMS;
  MCI_OVLY_RECT_PARMS = tagMCI_OVLY_RECT_PARMS;

{ parameter block for MCI_SAVE command message }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMCI_OVLY_SAVE_PARMS = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpfilename: string;
    rc: TRect;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMCI_OVLY_SAVE_PARMSA = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpfilename: string;
    rc: TRect;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMCI_OVLY_SAVE_PARMSW = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpfilename: string;
    rc: TRect;
  end;
  TMCI_Ovly_Save_Parms = tagMCI_OVLY_SAVE_PARMS;
  TMCI_Ovly_Save_ParmsA = tagMCI_OVLY_SAVE_PARMSA;
  TMCI_Ovly_Save_ParmsW = tagMCI_OVLY_SAVE_PARMSW;
  MCI_OVLY_SAVE_PARMS = tagMCI_OVLY_SAVE_PARMS;
  MCI_OVLY_SAVE_PARMSA = tagMCI_OVLY_SAVE_PARMSA;
  MCI_OVLY_SAVE_PARMSW = tagMCI_OVLY_SAVE_PARMSW;

{ parameter block for MCI_LOAD command message }
type
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
  tagMCI_OVLY_LOAD_PARMS = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpfilename: string;
    rc: TRect;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
  tagMCI_OVLY_LOAD_PARMSA = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpfilename: string;
    rc: TRect;
  end;
  [StructLayout(LayoutKind.Sequential, CharSet=CharSet.Unicode)]
  tagMCI_OVLY_LOAD_PARMSW = record
    dwCallback: DWORD;
    [MarshalAs(UnmanagedType.LPTStr)]
    lpfilename: string;
    rc: TRect;
  end;
  TMCI_Ovly_Load_Parms = tagMCI_OVLY_LOAD_PARMS;
  TMCI_Ovly_Load_ParmsA = tagMCI_OVLY_LOAD_PARMSA;
  TMCI_Ovly_Load_ParmsW = tagMCI_OVLY_LOAD_PARMSW;
  MCI_OVLY_LOAD_PARMS = tagMCI_OVLY_LOAD_PARMS;
  MCI_OVLY_LOAD_PARMSA = tagMCI_OVLY_LOAD_PARMSA;
  MCI_OVLY_LOAD_PARMSW = tagMCI_OVLY_LOAD_PARMSW;


{***************************************************************************

                        DISPLAY Driver extensions

***************************************************************************}

const
  NEWTRANSPARENT  = 3;           { use with SetBkMode() }
  QUERYROPSUPPORT = 40;          { use to determine ROP support }

{***************************************************************************

                        DIB Driver extensions

***************************************************************************}
const
  SELECTDIB       = 41;                      { DIB.DRV select dib escape }

function DIBIndex(N: Integer): Longint;

{***************************************************************************

                        ScreenSaver support

    The current application will receive a syscommand of SC_SCREENSAVE just
    before the screen saver is invoked.  If the app wishes to prevent a
    screen save, return a non-zero value, otherwise call DefWindowProc().

***************************************************************************}

const
  SC_SCREENSAVE   = $F140;

  mmsyst = 'winmm.dll';

implementation

uses
  System.Security;

[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'auxGetDevCaps')]
function auxGetDevCaps; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'auxGetDevCapsA')]
function auxGetDevCapsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'auxGetDevCapsW')]
function auxGetDevCapsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'auxGetNumDevs')]
function auxGetNumDevs; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'auxGetVolume')]
function auxGetVolume; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'auxOutMessage')]
function auxOutMessage; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'auxSetVolume')]
function auxSetVolume; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'CloseDriver')]
function CloseDriver; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DefDriverProc')]
function DefDriverProc; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'DrvGetModuleHandle')]
function DrvGetModuleHandle; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'GetDriverModuleHandle')]
function GetDriverModuleHandle; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'joyGetDevCaps')]
function joyGetDevCaps; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'joyGetDevCapsA')]
function joyGetDevCapsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'joyGetDevCapsW')]
function joyGetDevCapsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'joyGetNumDevs')]
function joyGetNumDevs; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'joyGetPos')]
function joyGetPos; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'joyGetPosEx')]
function joyGetPosEx; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'joyGetThreshold')]
function joyGetThreshold; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'joyReleaseCapture')]
function joyReleaseCapture; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'joySetCapture')]
function joySetCapture; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'joySetThreshold')]
function joySetThreshold; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mciExecute')]
function mciExecute; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mciGetCreatorTask')]
function mciGetCreatorTask; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciGetDeviceID')]
function mciGetDeviceID; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mciGetDeviceIDA')]
function mciGetDeviceIDA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mciGetDeviceIDW')]
function mciGetDeviceIDW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciGetDeviceIDFromElementID')]
function mciGetDeviceIDFromElementID; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mciGetDeviceIDFromElementIDA')]
function mciGetDeviceIDFromElementIDA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mciGetDeviceIDFromElementIDW')]
function mciGetDeviceIDFromElementIDW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciGetErrorString')]
function mciGetErrorString; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mciGetErrorStringA')]
function mciGetErrorStringA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mciGetErrorStringW')]
function mciGetErrorStringW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mciGetYieldProc')]
function mciGetYieldProc; external;

[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; dwParam2: IntPtr): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Generic_Parms): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Open_Parms): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Play_Parms): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Record_Parms): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Seek_Parms): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Anim_Step_Parms): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Set_Parms): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Status_Parms): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_SaveParms): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Anim_Window_Parms): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_Anim_Rect_Parms): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendCommand')]
function mciSendCommand(mciId: MCIDEVICEID; uMessage: UINT;
  dwParam1: DWORD; var dwParam2: TMCI_GetDevCaps_Parms): MCIERROR; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mciSendCommandA')]
function mciSendCommandA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mciSendCommandW')]
function mciSendCommandW; external;

[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mciSendString')]
function mciSendString; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mciSendStringA')]
function mciSendStringA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mciSendStringW')]
function mciSendStringW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mciSetYieldProc')]
function mciSetYieldProc; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiConnect')]
function midiConnect; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiDisconnect')]
function midiDisconnect; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInAddBuffer')]
function midiInAddBuffer; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInClose')]
function midiInClose; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'midiInGetDevCaps')]
function midiInGetDevCaps; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInGetDevCapsA')]
function midiInGetDevCapsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'midiInGetDevCapsW')]
function midiInGetDevCapsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'midiInGetErrorText')]
function midiInGetErrorText; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInGetErrorTextA')]
function midiInGetErrorTextA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'midiInGetErrorTextW')]
function midiInGetErrorTextW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInGetID')]
function midiInGetID; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInGetNumDevs')]
function midiInGetNumDevs; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInMessage')]
function midiInMessage; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInOpen')]
function midiInOpen; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInPrepareHeader')]
function midiInPrepareHeader; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInReset')]
function midiInReset; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInStart')]
function midiInStart; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInStop')]
function midiInStop; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiInUnprepareHeader')]
function midiInUnprepareHeader; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutCacheDrumPatches')]
function midiOutCacheDrumPatches; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutCachePatches')]
function midiOutCachePatches; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutClose')]
function midiOutClose; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'midiOutGetDevCaps')]
function midiOutGetDevCaps; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutGetDevCapsA')]
function midiOutGetDevCapsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'midiOutGetDevCapsW')]
function midiOutGetDevCapsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'midiOutGetErrorText')]
function midiOutGetErrorText; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutGetErrorTextA')]
function midiOutGetErrorTextA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'midiOutGetErrorTextW')]
function midiOutGetErrorTextW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutGetID')]
function midiOutGetID; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutGetNumDevs')]
function midiOutGetNumDevs; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutGetVolume')]
function midiOutGetVolume; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutLongMsg')]
function midiOutLongMsg; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutMessage')]
function midiOutMessage; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutOpen')]
function midiOutOpen; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutPrepareHeader')]
function midiOutPrepareHeader; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutReset')]
function midiOutReset; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutSetVolume')]
function midiOutSetVolume; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutShortMsg')]
function midiOutShortMsg; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiOutUnprepareHeader')]
function midiOutUnprepareHeader; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiStreamClose')]
function midiStreamClose; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiStreamOpen')]
function midiStreamOpen; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiStreamOut')]
function midiStreamOut; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiStreamPause')]
function midiStreamPause; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiStreamPosition')]
function midiStreamPosition; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiStreamProperty')]
function midiStreamProperty(hms: HMIDISTRM; var lppropdata: TMidiPropTempo; dwProperty: DWORD): MMRESULT; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiStreamProperty')]
function midiStreamProperty(hms: HMIDISTRM; var lppropdata: TMidiPropTimeDiv; dwProperty: DWORD): MMRESULT; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiStreamRestart')]
function midiStreamRestart; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'midiStreamStop')]
function midiStreamStop; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mixerClose')]
function mixerClose; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mixerGetControlDetails')]
function mixerGetControlDetails; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mixerGetControlDetailsA')]
function mixerGetControlDetailsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mixerGetControlDetailsW')]
function mixerGetControlDetailsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mixerGetDevCaps')]
function mixerGetDevCaps; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mixerGetDevCapsA')]
function mixerGetDevCapsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mixerGetDevCapsW')]
function mixerGetDevCapsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mixerGetID')]
function mixerGetID; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mixerGetLineControls')]
function mixerGetLineControls; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mixerGetLineControlsA')]
function mixerGetLineControlsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mixerGetLineControlsW')]
function mixerGetLineControlsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mixerGetLineInfo')]
function mixerGetLineInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mixerGetLineInfoA')]
function mixerGetLineInfoA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mixerGetLineInfoW')]
function mixerGetLineInfoW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mixerGetNumDevs')]
function mixerGetNumDevs; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mixerMessage')]
function mixerMessage; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mixerOpen')]
function mixerOpen; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mixerSetControlDetails')]
function mixerSetControlDetails; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioAdvance')]
function mmioAdvance; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioAscend')]
function mmioAscend; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioClose')]
function mmioClose; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioCreateChunk')]
function mmioCreateChunk; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioDescend')]
function mmioDescend(hmmio: HMMIO; var lpck: TMMCKInfo;
  var lpckParent: TMMCKInfo; uFlags: UINT): MMRESULT; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioDescend')]
function mmioDescend(hmmio: HMMIO; var lpck: TMMCKInfo;
  lpckParent: IntPtr; uFlags: UINT): MMRESULT; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioFlush')]
function mmioFlush; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioGetInfo')]
function mmioGetInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mmioInstallIOProc')]
function mmioInstallIOProc; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioInstallIOProcA')]
function mmioInstallIOProcA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mmioInstallIOProcW')]
function mmioInstallIOProcW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mmioOpen')]
function mmioOpen(szFileName: string; const lpmmioinfo: TMMIOInfo;
  dwOpenFlags: DWORD): HMMIO; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mmioOpen')]
function mmioOpen(szFileName: IntPtr; const lpmmioinfo: TMMIOInfo;
  dwOpenFlags: DWORD): HMMIO; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mmioOpen')]
function mmioOpen(szFileName: string; lpmmioinfo: IntPtr;
  dwOpenFlags: DWORD): HMMIO; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mmioOpen')]
function mmioOpen(szFileName, lpmmioinfo: IntPtr;
  dwOpenFlags: DWORD): HMMIO; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioOpenA')]
function mmioOpenA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mmioOpenW')]
function mmioOpenW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioRead')]
function mmioRead; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mmioRename')]
function mmioRename; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioRenameA')]
function mmioRenameA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mmioRenameW')]
function mmioRenameW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioSeek')]
function mmioSeek; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioSendMessage')]
function mmioSendMessage; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioSetBuffer')]
function mmioSetBuffer(hmmio: HMMIO; pchBuffer: TBytes; cchBuffer: Longint;
  uFlags: Word): MMRESULT; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioSetBuffer')]
function mmioSetBuffer(hmmio: HMMIO; pchBuffer: IntPtr; cchBuffer: Longint;
  uFlags: Word): MMRESULT; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioSetInfo')]
function mmioSetInfo; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'mmioStringToFOURCC')]
function mmioStringToFOURCC; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioStringToFOURCCA')]
function mmioStringToFOURCCA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'mmioStringToFOURCCW')]
function mmioStringToFOURCCW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmioWrite')]
function mmioWrite; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'mmsystemGetVersion')]
function mmsystemGetVersion; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'OpenDriver')]
function OpenDriver; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'PlaySound')]
function PlaySound; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'PlaySoundA')]
function PlaySoundA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'PlaySoundW')]
function PlaySoundW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'SendDriverMessage')]
function SendDriverMessage; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'sndPlaySound')]
function sndPlaySound(lpszSoundName: string; uFlags: UINT): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'sndPlaySound')]
function sndPlaySound(lpszSoundName: IntPtr; uFlags: UINT): BOOL; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'sndPlaySoundA')]
function sndPlaySoundA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'sndPlaySoundW')]
function sndPlaySoundW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'timeBeginPeriod')]
function timeBeginPeriod; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'timeEndPeriod')]
function timeEndPeriod; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'timeGetDevCaps')]
function timeGetDevCaps; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'timeGetSystemTime')]
function timeGetSystemTime; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'timeGetTime')]
function timeGetTime; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'timeKillEvent')]
function timeKillEvent; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'timeSetEvent')]
function timeSetEvent; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInAddBuffer')]
function waveInAddBuffer; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInClose')]
function waveInClose; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'waveInGetDevCaps')]
function waveInGetDevCaps; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInGetDevCapsA')]
function waveInGetDevCapsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'waveInGetDevCapsW')]
function waveInGetDevCapsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'waveInGetErrorText')]
function waveInGetErrorText; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInGetErrorTextA')]
function waveInGetErrorTextA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'waveInGetErrorTextW')]
function waveInGetErrorTextW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInGetID')]
function waveInGetID; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInGetNumDevs')]
function waveInGetNumDevs; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInGetPosition')]
function waveInGetPosition; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInMessage')]
function waveInMessage; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInOpen')]
function waveInOpen(out lphWaveIn: HWAVEIN; uDeviceID: UINT;
  const lpFormatEx: TWaveFormatEx; dwCallback, dwInstance, dwFlags: DWORD): MMRESULT; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInOpen')]
function waveInOpen(lphWaveIn: IntPtr; uDeviceID: UINT;
  const lpFormatEx: TWaveFormatEx; dwCallback, dwInstance, dwFlags: DWORD): MMRESULT; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInPrepareHeader')]
function waveInPrepareHeader; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInReset')]
function waveInReset; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInStart')]
function waveInStart; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInStop')]
function waveInStop; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveInUnprepareHeader')]
function waveInUnprepareHeader; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutBreakLoop')]
function waveOutBreakLoop; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutClose')]
function waveOutClose; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'waveOutGetDevCaps')]
function waveOutGetDevCaps; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutGetDevCapsA')]
function waveOutGetDevCapsA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'waveOutGetDevCapsW')]
function waveOutGetDevCapsW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Auto, SetLastError = True, EntryPoint = 'waveOutGetErrorText')]
function waveOutGetErrorText; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutGetErrorTextA')]
function waveOutGetErrorTextA; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Unicode, SetLastError = True, EntryPoint = 'waveOutGetErrorTextW')]
function waveOutGetErrorTextW; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutGetID')]
function waveOutGetID; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutGetNumDevs')]
function waveOutGetNumDevs; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutGetPitch')]
function waveOutGetPitch; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutGetPlaybackRate')]
function waveOutGetPlaybackRate; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutGetPosition')]
function waveOutGetPosition; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutGetVolume')]
function waveOutGetVolume; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutMessage')]
function waveOutMessage; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutOpen')]
function waveOutOpen(out lphWaveOut: HWaveOut; uDeviceID: UINT;
  const lpFormat: TWaveFormatEx; dwCallback, dwInstance, dwFlags: DWORD): MMRESULT; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutOpen')]
function waveOutOpen(lphWaveOut: IntPtr; uDeviceID: UINT;
  const lpFormat: TWaveFormatEx; dwCallback, dwInstance, dwFlags: DWORD): MMRESULT; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutPause')]
function waveOutPause; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutPrepareHeader')]
function waveOutPrepareHeader; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutReset')]
function waveOutReset; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutRestart')]
function waveOutRestart; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutSetPitch')]
function waveOutSetPitch; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutSetPlaybackRate')]
function waveOutSetPlaybackRate; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutSetVolume')]
function waveOutSetVolume; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutUnprepareHeader')]
function waveOutUnprepareHeader; external;
[SuppressUnmanagedCodeSecurity, DllImport(mmsyst, CharSet = CharSet.Ansi, SetLastError = True, EntryPoint = 'waveOutWrite')]
function waveOutWrite; external;

function mci_MSF_Minute(msf: Longint): Byte;
begin
  Result := LoByte(LoWord(msf));
end;

function mci_MSF_Second(msf: Longint): Byte;
begin
  Result := HiByte(LoWord(msf));
end;

function mci_MSF_Frame(msf: Longint): Byte;
begin
  Result := LoByte(HiWord(msf));
end;

function mci_Make_MSF(m, s, f: Byte): Longint;
begin
  Result := Longint(m or (s shl 8) or (f shl 16));
end;

function mci_TMSF_Track(tmsf: Longint): Byte;
begin
  Result := LoByte(LoWord(tmsf));
end;

function mci_TMSF_Minute(tmsf: Longint): Byte;
begin
  Result := HiByte(LoWord(tmsf));
end;

function mci_TMSF_Second(tmsf: Longint): Byte;
begin
  Result := LoByte(HiWord(tmsf));
end;

function mci_TMSF_Frame(tmsf: Longint): Byte;
begin
  Result := HiByte(HiWord(tmsf));
end;

function mci_Make_TMSF(t, m, s, f: Byte): Longint;
begin
  Result := Longint(t or (m shl 8) or (s shl 16) or (f shl 24));
end;

function mci_HMS_Hour(hms: Longint): Byte;
begin
  Result := LoByte(LoWord(hms));
end;

function mci_HMS_Minute(hms: Longint): Byte;
begin
  Result := HiByte(LoWord(hms));
end;

function mci_HMS_Second(hms: Longint): Byte;
begin
  Result := LoByte(HiWord(hms));
end;

function mci_Make_HMS(h, m, s: Byte): Longint;
begin
  Result := Longint(h or (m shl 8) or (s shl 16));
end;

function DIBIndex(N: Integer): Longint;
begin
  Result := MakeLong(N, $10FF);
end;

end.
